/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.List;

class WorkflowContextImpl
implements WorkflowContext {
    private final WorkflowClock clock;
    private final DecisionTask decisionTask;
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion;
    private ComponentVersions componentVersions;
    private WorkflowExecutionStartedEventAttributes workflowStartedEventAttributes;

    public WorkflowContextImpl(DecisionTask decisionTask, WorkflowClock clock) {
        this.decisionTask = decisionTask;
        this.clock = clock;
        HistoryEvent firstHistoryEvent = (HistoryEvent)decisionTask.getEvents().get(0);
        this.workflowStartedEventAttributes = firstHistoryEvent.getWorkflowExecutionStartedEventAttributes();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.decisionTask.getWorkflowExecution();
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.decisionTask.getWorkflowType();
    }

    @Override
    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested(boolean flag) {
        this.cancelRequested = flag;
    }

    @Override
    public ContinueAsNewWorkflowExecutionParameters getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    @Override
    public void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.continueAsNewOnCompletion = continueParameters;
    }

    @Override
    public WorkflowExecution getParentWorkflowExecution() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getParentWorkflowExecution();
    }

    @Override
    public List<String> getTagList() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getTagList();
    }

    @Override
    public ChildPolicy getChildPolicy() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ChildPolicy.fromValue((String)attributes.getChildPolicy());
    }

    @Override
    public String getContinuedExecutionRunId() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getContinuedExecutionRunId();
    }

    @Override
    public long getExecutionStartToCloseTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String result = attributes.getExecutionStartToCloseTimeout();
        return FlowHelpers.durationToSeconds(result);
    }

    @Override
    public String getTaskList() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getTaskList().getName();
    }

    @Override
    public String getLambdaRole() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getLambdaRole();
    }

    private WorkflowExecutionStartedEventAttributes getWorkflowStartedEventAttributes() {
        return this.workflowStartedEventAttributes;
    }

    @Override
    public int getTaskPriority() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String result = attributes.getTaskPriority();
        return FlowHelpers.taskPriorityToInt(result);
    }

    @Override
    public boolean isImplementationVersion(String component, int version) {
        return this.componentVersions.isVersion(component, version, this.clock.isReplaying());
    }

    @Override
    public Integer getVersion(String component) {
        return this.componentVersions.getCurrentVersion(component);
    }

    void setComponentVersions(ComponentVersions componentVersions) {
        this.componentVersions = componentVersions;
    }
}

