/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.EventType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HistoryHelper {
    private static final Log historyLog = LogFactory.getLog((String)(HistoryHelper.class.getName() + ".history"));
    private final SingleDecisionEventsIterator singleDecisionEventsIterator;
    private SingleDecisionData currentDecisionData;

    public HistoryHelper(Iterator<DecisionTask> decisionTasks) {
        this.singleDecisionEventsIterator = new SingleDecisionEventsIterator(decisionTasks);
    }

    public List<HistoryEvent> getSingleDecisionEvents() {
        if (!this.singleDecisionEventsIterator.hasNext()) {
            this.currentDecisionData = null;
            return null;
        }
        this.currentDecisionData = this.singleDecisionEventsIterator.next();
        return this.currentDecisionData.getDecisionEvents();
    }

    public DecisionTask getDecisionTask() {
        return this.singleDecisionEventsIterator.getDecisionTask();
    }

    public String getWorkflowContextData() {
        if (this.currentDecisionData == null) {
            throw new IllegalStateException();
        }
        return this.currentDecisionData.getWorkflowContextData();
    }

    public long getReplayCurrentTimeMilliseconds() {
        if (this.currentDecisionData == null) {
            throw new IllegalStateException();
        }
        return this.currentDecisionData.getReplayCurrentTimeMilliseconds();
    }

    public ComponentVersions getComponentVersions() {
        return this.singleDecisionEventsIterator.getComponentVersions();
    }

    public long getLastNonReplayEventId() {
        Long result = this.getDecisionTask().getPreviousStartedEventId();
        if (result == null) {
            return 0L;
        }
        return result;
    }

    class EventsIterator
    implements Iterator<HistoryEvent> {
        private final Iterator<DecisionTask> decisionTasks;
        private DecisionTask decisionTask;
        private List<HistoryEvent> events;
        private int index;

        public EventsIterator(Iterator<DecisionTask> decisionTasks) {
            this.decisionTasks = decisionTasks;
            if (decisionTasks.hasNext()) {
                this.decisionTask = decisionTasks.next();
                this.events = this.decisionTask.getEvents();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
            } else {
                this.decisionTask = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.decisionTask != null && (this.index < this.events.size() || this.decisionTasks.hasNext());
        }

        @Override
        public HistoryEvent next() {
            if (this.index == this.events.size()) {
                this.decisionTask = this.decisionTasks.next();
                this.events = this.decisionTask.getEvents();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
                this.index = 0;
            }
            return this.events.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public DecisionTask getDecisionTask() {
            return this.decisionTask;
        }

        public List<HistoryEvent> getEvents() {
            return this.events;
        }
    }

    class SingleDecisionEventsIterator
    implements Iterator<SingleDecisionData> {
        private final EventsIterator events;
        private final ComponentVersions componentVersions = new ComponentVersions();
        private String workflowContextData;
        private SingleDecisionData current;
        private SingleDecisionData next;

        public SingleDecisionEventsIterator(Iterator<DecisionTask> decisionTasks) {
            this.events = new EventsIterator(decisionTasks);
            this.fillNext();
            this.current = this.next;
            this.fillNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public SingleDecisionData next() {
            SingleDecisionData result = this.current;
            this.current = this.next;
            this.fillNext();
            return result;
        }

        private void fillNext() {
            boolean decisionTaskTimedOut = false;
            ArrayList<Object> decisionStartToCompletionEvents = new ArrayList<HistoryEvent>();
            ArrayList<HistoryEvent> decisionCompletionToStartEvents = new ArrayList<HistoryEvent>();
            boolean concurrentToDecision = true;
            int lastDecisionIndex = -1;
            long nextReplayCurrentTimeMilliseconds = -1L;
            while (this.events.hasNext()) {
                HistoryEvent event = this.events.next();
                EventType eventType = EventType.fromValue((String)event.getEventType());
                if (eventType == EventType.DecisionTaskCompleted) {
                    String executionContext = event.getDecisionTaskCompletedEventAttributes().getExecutionContext();
                    this.updateWorkflowContextDataAndComponentVersions(executionContext);
                    concurrentToDecision = false;
                    continue;
                }
                if (eventType == EventType.DecisionTaskStarted) {
                    nextReplayCurrentTimeMilliseconds = event.getEventTimestamp().getTime();
                    if (!decisionTaskTimedOut) break;
                    this.current.getDecisionEvents().addAll(decisionStartToCompletionEvents);
                    decisionStartToCompletionEvents = new ArrayList();
                    decisionTaskTimedOut = false;
                    continue;
                }
                if (eventType.equals((Object)EventType.DecisionTaskTimedOut)) {
                    decisionTaskTimedOut = true;
                    continue;
                }
                if (eventType == EventType.DecisionTaskScheduled || eventType == EventType.MarkerRecorded || eventType == EventType.RecordMarkerFailed) continue;
                if (concurrentToDecision) {
                    decisionStartToCompletionEvents.add(event);
                    continue;
                }
                if (this.isDecisionEvent(eventType)) {
                    lastDecisionIndex = decisionCompletionToStartEvents.size();
                }
                decisionCompletionToStartEvents.add(event);
            }
            List<HistoryEvent> nextEvents = this.reorderEvents(decisionStartToCompletionEvents, decisionCompletionToStartEvents, lastDecisionIndex);
            this.next = new SingleDecisionData(nextEvents, nextReplayCurrentTimeMilliseconds, this.workflowContextData);
        }

        public DecisionTask getDecisionTask() {
            return this.events.getDecisionTask();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean isDecisionEvent(EventType eventType) {
            switch (eventType) {
                case ActivityTaskScheduled: 
                case ScheduleActivityTaskFailed: 
                case ActivityTaskCancelRequested: 
                case RequestCancelActivityTaskFailed: 
                case MarkerRecorded: 
                case RecordMarkerFailed: 
                case WorkflowExecutionCompleted: 
                case CompleteWorkflowExecutionFailed: 
                case WorkflowExecutionFailed: 
                case FailWorkflowExecutionFailed: 
                case WorkflowExecutionCanceled: 
                case CancelWorkflowExecutionFailed: 
                case WorkflowExecutionContinuedAsNew: 
                case ContinueAsNewWorkflowExecutionFailed: 
                case TimerStarted: 
                case StartTimerFailed: 
                case TimerCanceled: 
                case CancelTimerFailed: 
                case SignalExternalWorkflowExecutionInitiated: 
                case SignalExternalWorkflowExecutionFailed: 
                case RequestCancelExternalWorkflowExecutionInitiated: 
                case RequestCancelExternalWorkflowExecutionFailed: 
                case StartChildWorkflowExecutionInitiated: 
                case StartChildWorkflowExecutionFailed: {
                    return true;
                }
            }
            return false;
        }

        private List<HistoryEvent> reorderEvents(List<HistoryEvent> decisionStartToCompletionEvents, List<HistoryEvent> decisionCompletionToStartEvents, int lastDecisionIndex) {
            int size = decisionStartToCompletionEvents.size() + decisionStartToCompletionEvents.size();
            ArrayList<HistoryEvent> reordered = new ArrayList<HistoryEvent>(size);
            if (lastDecisionIndex >= 0) {
                reordered.addAll(decisionCompletionToStartEvents.subList(0, lastDecisionIndex + 1));
            }
            reordered.addAll(decisionStartToCompletionEvents);
            if (decisionCompletionToStartEvents.size() > lastDecisionIndex + 1) {
                reordered.addAll(decisionCompletionToStartEvents.subList(lastDecisionIndex + 1, decisionCompletionToStartEvents.size()));
            }
            return reordered;
        }

        private void updateWorkflowContextDataAndComponentVersions(String executionContext) {
            if (executionContext != null && executionContext.startsWith("*component_version*")) {
                Scanner scanner = new Scanner(executionContext);
                scanner.useDelimiter("\n|\t");
                scanner.next();
                int size = scanner.nextInt();
                for (int i = 0; i < size; ++i) {
                    String componentName = scanner.next();
                    int version = scanner.nextInt();
                    if (componentName == null) {
                        throw new IncompatibleWorkflowDefinition("null component name in line " + i + " in the execution context: " + executionContext);
                    }
                    this.componentVersions.setVersionFromHistory(componentName, version);
                }
                this.workflowContextData = scanner.next(".*");
            } else {
                this.workflowContextData = executionContext;
            }
        }

        public ComponentVersions getComponentVersions() {
            return this.componentVersions;
        }
    }

    private class SingleDecisionData {
        private final List<HistoryEvent> decisionEvents;
        private final long replayCurrentTimeMilliseconds;
        private final String workflowContextData;

        public SingleDecisionData(List<HistoryEvent> decisionEvents, long replayCurrentTimeMilliseconds, String workflowContextData) {
            this.decisionEvents = decisionEvents;
            this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
            this.workflowContextData = workflowContextData;
        }

        public List<HistoryEvent> getDecisionEvents() {
            return this.decisionEvents;
        }

        public long getReplayCurrentTimeMilliseconds() {
            return this.replayCurrentTimeMilliseconds;
        }

        public String getWorkflowContextData() {
            return this.workflowContextData;
        }
    }
}

