/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DefaultChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.retry.ThrottlingRetrier;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.TypeAlreadyExistsException;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericWorkflowWorker
extends GenericWorker<DecisionTaskPoller.DecisionTaskIterator> {
    private static final Log log = LogFactory.getLog(GenericWorkflowWorker.class);
    private static final String THREAD_NAME_PREFIX = "SWF Decider ";
    private WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory;
    private ChildWorkflowIdHandler childWorkflowIdHandler = new DefaultChildWorkflowIdHandler();

    public GenericWorkflowWorker() {
    }

    public GenericWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        super(service, domain, taskListToPoll, null);
    }

    public GenericWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll, SimpleWorkflowClientConfig config) {
        super(service, domain, taskListToPoll, config);
    }

    protected DecisionTaskPoller createWorkflowPoller() {
        return new DecisionTaskPoller();
    }

    @Override
    protected TaskPoller<DecisionTaskPoller.DecisionTaskIterator> createPoller() {
        DecisionTaskPoller result = new DecisionTaskPoller();
        result.setDecisionTaskHandler(new AsyncDecisionTaskHandler(this.workflowDefinitionFactoryFactory, this.childWorkflowIdHandler));
        result.setDomain(this.getDomain());
        result.setIdentity(this.getIdentity());
        result.setService(this.getService());
        result.setTaskListToPoll(this.getTaskListToPoll());
        return result;
    }

    @Override
    public void registerTypesToPoll() {
        GenericWorkflowWorker.registerWorkflowTypes(this.service, this.domain, this.getTaskListToPoll(), this.workflowDefinitionFactoryFactory);
    }

    public static void registerWorkflowTypes(AmazonSimpleWorkflow service, String domain, String defaultTaskList, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        GenericWorkflowWorker.registerWorkflowTypes(service, domain, defaultTaskList, workflowDefinitionFactoryFactory, null);
    }

    public static void registerWorkflowTypes(AmazonSimpleWorkflow service, String domain, String defaultTaskList, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, SimpleWorkflowClientConfig config) {
        for (WorkflowType typeToRegister : workflowDefinitionFactoryFactory.getWorkflowTypesToRegister()) {
            WorkflowDefinitionFactory workflowDefinitionFactory = workflowDefinitionFactoryFactory.getWorkflowDefinitionFactory(typeToRegister);
            WorkflowTypeRegistrationOptions registrationOptions = workflowDefinitionFactory.getWorkflowRegistrationOptions();
            if (registrationOptions == null) continue;
            WorkflowType workflowType = workflowDefinitionFactory.getWorkflowType();
            try {
                GenericWorkflowWorker.registerWorkflowType(service, domain, workflowType, registrationOptions, defaultTaskList, config);
            }
            catch (TypeAlreadyExistsException ex) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Workflow Type already registered: " + workflowType));
            }
        }
    }

    public static void registerWorkflowType(AmazonSimpleWorkflow service, String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList) {
        GenericWorkflowWorker.registerWorkflowType(service, domain, workflowType, registrationOptions, defaultTaskList, null);
    }

    public static void registerWorkflowType(AmazonSimpleWorkflow service, String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList, SimpleWorkflowClientConfig config) {
        RegisterWorkflowTypeRequest registerWorkflow = GenericWorkflowWorker.buildRegisterWorkflowTypeRequest(domain, workflowType, registrationOptions, defaultTaskList);
        RequestTimeoutHelper.overrideControlPlaneRequestTimeout((AmazonWebServiceRequest)registerWorkflow, config);
        GenericWorkflowWorker.registerWorkflowTypeWithRetry(service, registerWorkflow);
    }

    private static RegisterWorkflowTypeRequest buildRegisterWorkflowTypeRequest(String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList) {
        RegisterWorkflowTypeRequest registerWorkflow = new RegisterWorkflowTypeRequest();
        registerWorkflow.setDomain(domain);
        registerWorkflow.setName(workflowType.getName());
        registerWorkflow.setVersion(workflowType.getVersion());
        String taskList = registrationOptions.getDefaultTaskList();
        if (taskList == null) {
            taskList = defaultTaskList;
        } else if (taskList.equals("NO_DEFAULT_TASK_LIST")) {
            taskList = null;
        }
        if (taskList != null && !taskList.isEmpty()) {
            registerWorkflow.setDefaultTaskList(new TaskList().withName(taskList));
        }
        registerWorkflow.setDefaultChildPolicy(registrationOptions.getDefaultChildPolicy().toString());
        registerWorkflow.setDefaultTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskStartToCloseTimeoutSeconds()));
        registerWorkflow.setDefaultExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultExecutionStartToCloseTimeoutSeconds()));
        registerWorkflow.setDefaultTaskPriority(FlowHelpers.taskPriorityToString(registrationOptions.getDefaultTaskPriority()));
        registerWorkflow.setDefaultLambdaRole(registrationOptions.getDefaultLambdaRole());
        String description = registrationOptions.getDescription();
        if (description != null) {
            registerWorkflow.setDescription(description);
        }
        return registerWorkflow;
    }

    private static void registerWorkflowTypeWithRetry(AmazonSimpleWorkflow service, RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        ThrottlingRetrier retrier = new ThrottlingRetrier(GenericWorkflowWorker.getRegisterTypeThrottledRetryParameters());
        retrier.retry(() -> service.registerWorkflowType(registerWorkflowTypeRequest));
    }

    @Override
    protected void checkRequiredProperties() {
        this.checkRequiredProperty(this.workflowDefinitionFactoryFactory, "workflowDefinitionFactoryFactory");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[super=" + super.toString() + ", workflowDefinitionFactoryFactory=" + this.workflowDefinitionFactoryFactory + "]";
    }

    @Override
    protected String getPollThreadNamePrefix() {
        return THREAD_NAME_PREFIX + this.getTaskListToPoll() + " ";
    }

    public WorkflowDefinitionFactoryFactory getWorkflowDefinitionFactoryFactory() {
        return this.workflowDefinitionFactoryFactory;
    }

    public void setWorkflowDefinitionFactoryFactory(WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        this.workflowDefinitionFactoryFactory = workflowDefinitionFactoryFactory;
    }

    public void setChildWorkflowIdHandler(ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.childWorkflowIdHandler = childWorkflowIdHandler;
    }
}

