/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowTerminatedException;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.SignalExternalWorkflowException;
import com.amazonaws.services.simpleworkflow.flow.StartChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Functor;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowReply;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionCanceledEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionCompletedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionTerminatedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionTimedOutEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ExternalWorkflowExecutionSignaledEventAttributes;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.SignalExternalWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.SignalExternalWorkflowExecutionFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionFailedCause;
import com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;

class GenericWorkflowClientImpl
implements GenericWorkflowClient {
    private final DecisionsHelper decisions;
    private final WorkflowContext workflowContext;
    private final Map<String, OpenRequestInfo<StartChildWorkflowReply, WorkflowType>> scheduledExternalWorkflows = new HashMap<String, OpenRequestInfo<StartChildWorkflowReply, WorkflowType>>();
    private final Map<String, OpenRequestInfo<Void, Void>> scheduledSignals = new HashMap<String, OpenRequestInfo<Void, Void>>();

    GenericWorkflowClientImpl(DecisionsHelper decisions, WorkflowContext workflowContext) {
        this.decisions = decisions;
        this.workflowContext = workflowContext;
    }

    @Override
    public Promise<StartChildWorkflowReply> startChildWorkflow(StartChildWorkflowExecutionParameters parameters) {
        String taskList;
        ChildPolicy childPolicy;
        final OpenRequestInfo context = new OpenRequestInfo();
        final StartChildWorkflowExecutionDecisionAttributes attributes = new StartChildWorkflowExecutionDecisionAttributes();
        attributes.setWorkflowType(parameters.getWorkflowType());
        String workflowId = parameters.getWorkflowId();
        if (workflowId == null) {
            workflowId = this.generateUniqueId();
        }
        attributes.setWorkflowId(workflowId);
        attributes.setInput(parameters.getInput());
        attributes.setExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getExecutionStartToCloseTimeoutSeconds()));
        attributes.setTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getTaskStartToCloseTimeoutSeconds()));
        attributes.setTaskPriority(FlowHelpers.taskPriorityToString(parameters.getTaskPriority()));
        List<String> tagList = parameters.getTagList();
        if (tagList != null) {
            attributes.setTagList(tagList);
        }
        if ((childPolicy = parameters.getChildPolicy()) != null) {
            attributes.setChildPolicy(childPolicy);
        }
        if ((taskList = parameters.getTaskList()) != null && !taskList.isEmpty()) {
            attributes.setTaskList(new TaskList().withName(taskList));
        }
        attributes.setLambdaRole(parameters.getLambdaRole());
        String taskName = "workflowId=" + workflowId + ", workflowType=" + attributes.getWorkflowType();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                context.setCompletionHandle(handle);
                String workflowId = attributes.getWorkflowId();
                if (GenericWorkflowClientImpl.this.scheduledExternalWorkflows.containsKey(GenericWorkflowClientImpl.this.decisions.getActualChildWorkflowId(workflowId))) {
                    WorkflowExecution workflowExecution = new WorkflowExecution();
                    workflowExecution.setWorkflowId(workflowId);
                    WorkflowType workflowType = attributes.getWorkflowType();
                    long fakeEventId = -1L;
                    handle.fail(new StartChildWorkflowFailedException(fakeEventId, workflowExecution, workflowType, StartChildWorkflowExecutionFailedCause.WORKFLOW_ALREADY_RUNNING.toString()));
                    return new ChildWorkflowCancellationHandler(workflowId, handle);
                }
                GenericWorkflowClientImpl.this.decisions.startChildWorkflowExecution(attributes);
                GenericWorkflowClientImpl.this.scheduledExternalWorkflows.put(workflowId, context);
                return new ChildWorkflowCancellationHandler(workflowId, handle);
            }
        }.setName(taskName);
        context.setResultDescription("startChildWorkflow " + taskName);
        return context.getResult();
    }

    @Override
    public Promise<String> startChildWorkflow(String workflow, String version, String input) {
        StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters();
        parameters.setWorkflowType(new WorkflowType().withName(workflow).withVersion(version));
        parameters.setInput(input);
        final Promise<StartChildWorkflowReply> started = this.startChildWorkflow(parameters);
        return new Functor<String>(new Promise[]{started}){

            @Override
            protected Promise<String> doExecute() throws Throwable {
                return ((StartChildWorkflowReply)started.get()).getResult();
            }
        };
    }

    @Override
    public Promise<String> startChildWorkflow(final String workflow, final String version, final Promise<String> input) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(GenericWorkflowClientImpl.this.startChildWorkflow(workflow, version, (String)input.get()));
            }
        };
        return result;
    }

    @Override
    public Promise<Void> signalWorkflowExecution(SignalExternalWorkflowParameters parameters) {
        final OpenRequestInfo context = new OpenRequestInfo();
        final SignalExternalWorkflowExecutionDecisionAttributes attributes = new SignalExternalWorkflowExecutionDecisionAttributes();
        String signalId = this.decisions.getNextId();
        attributes.setControl(signalId);
        attributes.setSignalName(parameters.getSignalName());
        attributes.setInput(parameters.getInput());
        attributes.setRunId(parameters.getRunId());
        attributes.setWorkflowId(parameters.getWorkflowId());
        String taskName = "signalId=" + signalId + ", workflowId=" + parameters.getWorkflowId() + ", workflowRunId=" + parameters.getRunId();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(final ExternalTaskCompletionHandle handle) throws Throwable {
                GenericWorkflowClientImpl.this.decisions.signalExternalWorkflowExecution(attributes);
                context.setCompletionHandle(handle);
                final String finalSignalId = attributes.getControl();
                GenericWorkflowClientImpl.this.scheduledSignals.put(finalSignalId, context);
                return new ExternalTaskCancellationHandler(){

                    @Override
                    public void handleCancellation(Throwable cause) {
                        GenericWorkflowClientImpl.this.decisions.cancelSignalExternalWorkflowExecution(finalSignalId, null);
                        OpenRequestInfo scheduled = (OpenRequestInfo)GenericWorkflowClientImpl.this.scheduledSignals.remove(finalSignalId);
                        if (scheduled == null) {
                            throw new IllegalArgumentException("Signal \"" + finalSignalId + "\" wasn't scheduled");
                        }
                        handle.complete();
                    }
                };
            }
        }.setName(taskName);
        context.setResultDescription("signalWorkflowExecution " + taskName);
        return context.getResult();
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelExternalWorkflowExecutionDecisionAttributes attributes = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
        attributes.setWorkflowId(this.decisions.getActualChildWorkflowId(execution.getWorkflowId()));
        attributes.setRunId(execution.getRunId());
        this.decisions.requestCancelExternalWorkflowExecution(attributes, null);
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.workflowContext.setContinueAsNewOnCompletion(continueParameters);
    }

    @Override
    public String generateUniqueId() {
        return this.decisions.getChildWorkflowIdHandler().generateWorkflowId(this.workflowContext.getWorkflowExecution(), this.decisions::getNextId);
    }

    public void handleChildWorkflowExecutionCancelRequested(HistoryEvent event) {
        this.decisions.handleChildWorkflowExecutionCancelRequested(event);
    }

    void handleChildWorkflowExecutionCanceled(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionCanceledEventAttributes attributes = event.getChildWorkflowExecutionCanceledEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionCanceled(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            CancellationException e = new CancellationException();
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(e);
        }
    }

    void handleChildWorkflowExecutionInitiated(HistoryEvent event) {
        String requestedWorkflowId;
        String actualWorkflowId = event.getStartChildWorkflowExecutionInitiatedEventAttributes().getWorkflowId();
        if (!actualWorkflowId.equals(requestedWorkflowId = this.decisions.getChildWorkflowIdHandler().extractRequestedWorkflowId(actualWorkflowId))) {
            OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = this.scheduledExternalWorkflows.remove(requestedWorkflowId);
            this.scheduledExternalWorkflows.put(actualWorkflowId, scheduled);
        }
        this.decisions.handleStartChildWorkflowExecutionInitiated(event);
    }

    void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.getChildWorkflowExecutionStartedEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        this.decisions.handleChildWorkflowExecutionStarted(event);
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = this.scheduledExternalWorkflows.get(workflowId);
        if (scheduled != null) {
            String runId = attributes.getWorkflowExecution().getRunId();
            Settable<StartChildWorkflowReply> result = scheduled.getResult();
            if (!result.isReady()) {
                String description = "startChildWorkflow workflowId=" + workflowId + ", runId=" + runId;
                result.set(new StartChildWorkflowReplyImpl(workflowId, runId, description));
            }
        }
    }

    void handleChildWorkflowExecutionTimedOut(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionTimedOutEventAttributes attributes = event.getChildWorkflowExecutionTimedOutEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ChildWorkflowTimedOutException failure = new ChildWorkflowTimedOutException(event.getEventId(), execution, attributes.getWorkflowType());
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleChildWorkflowExecutionTerminated(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionTerminatedEventAttributes attributes = event.getChildWorkflowExecutionTerminatedEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ChildWorkflowTerminatedException failure = new ChildWorkflowTerminatedException(event.getEventId(), execution, attributes.getWorkflowType());
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        if (this.decisions.handleStartChildWorkflowExecutionFailed(event)) {
            StartChildWorkflowExecutionFailedEventAttributes attributes = event.getStartChildWorkflowExecutionFailedEventAttributes();
            String actualWorkflowId = attributes.getWorkflowId();
            String requestedWorkflowId = this.decisions.getChildWorkflowIdHandler().extractRequestedWorkflowId(actualWorkflowId);
            String workflowId = null;
            OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = null;
            if (this.scheduledExternalWorkflows.containsKey(requestedWorkflowId)) {
                scheduled = this.scheduledExternalWorkflows.remove(requestedWorkflowId);
                workflowId = requestedWorkflowId;
            } else if (this.scheduledExternalWorkflows.containsKey(actualWorkflowId)) {
                scheduled = this.scheduledExternalWorkflows.remove(actualWorkflowId);
                workflowId = actualWorkflowId;
            }
            if (scheduled != null) {
                WorkflowExecution workflowExecution = new WorkflowExecution();
                workflowExecution.setWorkflowId(workflowId);
                WorkflowType workflowType = attributes.getWorkflowType();
                String cause = attributes.getCause();
                StartChildWorkflowFailedException failure = new StartChildWorkflowFailedException(event.getEventId(), workflowExecution, workflowType, cause);
                ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
                context.fail(failure);
            }
        }
    }

    void handleChildWorkflowExecutionFailed(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionFailedEventAttributes attributes = event.getChildWorkflowExecutionFailedEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            String reason = attributes.getReason();
            String details = attributes.getDetails();
            ChildWorkflowFailedException failure = new ChildWorkflowFailedException(event.getEventId(), execution, attributes.getWorkflowType(), reason, details);
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleChildWorkflowExecutionCompleted(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionCompletedEventAttributes attributes = event.getChildWorkflowExecutionCompletedEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            String result = attributes.getResult();
            StartChildWorkflowReplyImpl startedReply = (StartChildWorkflowReplyImpl)scheduled.getResult().get();
            startedReply.setResult(result);
            context.complete();
        }
    }

    void handleSignalExternalWorkflowExecutionFailed(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalContextAndResult;
        SignalExternalWorkflowExecutionFailedEventAttributes attributes = event.getSignalExternalWorkflowExecutionFailedEventAttributes();
        String signalId = attributes.getControl();
        if (this.decisions.handleSignalExternalWorkflowExecutionFailed(signalId) && (signalContextAndResult = this.scheduledSignals.remove(signalId)) != null) {
            WorkflowExecution signaledExecution = new WorkflowExecution();
            signaledExecution.setWorkflowId(attributes.getWorkflowId());
            signaledExecution.setRunId(attributes.getRunId());
            SignalExternalWorkflowException failure = new SignalExternalWorkflowException(event.getEventId(), signaledExecution, attributes.getCause());
            signalContextAndResult.getCompletionHandle().fail(failure);
        }
    }

    void handleExternalWorkflowExecutionSignaled(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalContextAndResult;
        ExternalWorkflowExecutionSignaledEventAttributes attributes = event.getExternalWorkflowExecutionSignaledEventAttributes();
        String signalId = this.decisions.getSignalIdFromExternalWorkflowExecutionSignaled(attributes.getInitiatedEventId());
        if (this.decisions.handleExternalWorkflowExecutionSignaled(signalId) && (signalContextAndResult = this.scheduledSignals.remove(signalId)) != null) {
            signalContextAndResult.getResult().set(null);
            signalContextAndResult.getCompletionHandle().complete();
        }
    }

    private final class ChildWorkflowCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String requestedWorkflowId;
        private final ExternalTaskCompletionHandle handle;

        private ChildWorkflowCancellationHandler(String requestedWorkflowId, ExternalTaskCompletionHandle handle) {
            this.requestedWorkflowId = requestedWorkflowId;
            this.handle = handle;
        }

        @Override
        public void handleCancellation(Throwable cause) {
            RequestCancelExternalWorkflowExecutionDecisionAttributes cancelAttributes = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
            final String actualWorkflowId = GenericWorkflowClientImpl.this.decisions.getActualChildWorkflowId(this.requestedWorkflowId);
            cancelAttributes.setWorkflowId(actualWorkflowId);
            GenericWorkflowClientImpl.this.decisions.requestCancelExternalWorkflowExecution(cancelAttributes, new Runnable(){

                @Override
                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)GenericWorkflowClientImpl.this.scheduledExternalWorkflows.remove(actualWorkflowId);
                    if (scheduled == null) {
                        throw new IllegalArgumentException("Workflow \"" + actualWorkflowId + "\" wasn't scheduled");
                    }
                    ChildWorkflowCancellationHandler.this.handle.complete();
                }
            });
        }
    }

    private static class StartChildWorkflowReplyImpl
    implements StartChildWorkflowReply {
        private String workflowId;
        private String runId;
        private final Settable<String> result = new Settable();

        public StartChildWorkflowReplyImpl(String workflowId, String runId, String description) {
            this.runId = runId;
            this.workflowId = workflowId;
            this.result.setDescription(description);
        }

        @Override
        public String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public String getRunId() {
            return this.runId;
        }

        @Override
        public Promise<String> getResult() {
            return this.result;
        }

        public void setResult(String value) {
            this.result.set(value);
        }
    }
}

