/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.TerminateWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;

public class GenericWorkflowClientExternalImpl
implements GenericWorkflowClientExternal {
    private final String domain;
    private final AmazonSimpleWorkflow service;
    private SimpleWorkflowClientConfig config;

    public GenericWorkflowClientExternalImpl(AmazonSimpleWorkflow service, String domain) {
        this(service, domain, null);
    }

    public GenericWorkflowClientExternalImpl(AmazonSimpleWorkflow service, String domain, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.domain = domain;
        this.config = config;
    }

    @Override
    public WorkflowExecution startWorkflow(StartWorkflowExecutionParameters startParameters) {
        StartWorkflowExecutionRequest request = new StartWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setInput(startParameters.getInput());
        request.setExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getExecutionStartToCloseTimeout()));
        request.setTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getTaskStartToCloseTimeoutSeconds()));
        request.setTagList(startParameters.getTagList());
        String taskList = startParameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            request.setTaskList(new TaskList().withName(taskList));
        }
        request.setWorkflowId(startParameters.getWorkflowId());
        request.setWorkflowType(startParameters.getWorkflowType());
        request.setTaskPriority(FlowHelpers.taskPriorityToString(startParameters.getTaskPriority()));
        if (startParameters.getChildPolicy() != null) {
            request.setChildPolicy(startParameters.getChildPolicy());
        }
        request.setLambdaRole(startParameters.getLambdaRole());
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        Run result = this.service.startWorkflowExecution(request);
        WorkflowExecution execution = new WorkflowExecution().withRunId(result.getRunId()).withWorkflowId(request.getWorkflowId());
        return execution;
    }

    @Override
    public void signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        SignalWorkflowExecutionRequest request = new SignalWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setInput(signalParameters.getInput());
        request.setSignalName(signalParameters.getSignalName());
        request.setRunId(signalParameters.getRunId());
        request.setWorkflowId(signalParameters.getWorkflowId());
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.signalWorkflowExecution(request);
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelWorkflowExecutionRequest request = new RequestCancelWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setRunId(execution.getRunId());
        request.setWorkflowId(execution.getWorkflowId());
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.requestCancelWorkflowExecution(request);
    }

    @Override
    public String generateUniqueId() {
        String workflowId = UUID.randomUUID().toString();
        return workflowId;
    }

    @Override
    public String getWorkflowState(WorkflowExecution execution) {
        String result;
        String executionContext = this.getLatestWorkflowExecutionContext(execution);
        if (executionContext != null && executionContext.startsWith("*component_version*")) {
            Scanner scanner = new Scanner(executionContext);
            scanner.useDelimiter("\n|\t");
            scanner.next();
            int size = scanner.nextInt();
            for (int i = 0; i < size; ++i) {
                scanner.next();
                scanner.nextInt();
            }
            result = scanner.next(".*");
        } else {
            result = executionContext;
        }
        return result;
    }

    @Override
    public Map<String, Integer> getImplementationVersions(WorkflowExecution execution) {
        String executionContext = this.getLatestWorkflowExecutionContext(execution);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (executionContext.startsWith("*component_version*")) {
            Scanner scanner = new Scanner(executionContext);
            scanner.useDelimiter("\n|\t");
            scanner.next();
            int size = scanner.nextInt();
            for (int i = 0; i < size; ++i) {
                String componentName = scanner.next();
                int version = scanner.nextInt();
                result.put(componentName, version);
            }
        }
        return result;
    }

    private String getLatestWorkflowExecutionContext(WorkflowExecution execution) {
        DescribeWorkflowExecutionRequest request = new DescribeWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setExecution(execution);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        WorkflowExecutionDetail details = this.service.describeWorkflowExecution(request);
        String executionContext = details.getLatestExecutionContext();
        return executionContext;
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionParameters terminateParameters) {
        TerminateWorkflowExecutionRequest request = new TerminateWorkflowExecutionRequest();
        WorkflowExecution workflowExecution = terminateParameters.getWorkflowExecution();
        request.setWorkflowId(workflowExecution.getWorkflowId());
        request.setRunId(workflowExecution.getRunId());
        request.setDomain(this.domain);
        request.setDetails(terminateParameters.getDetails());
        request.setReason(terminateParameters.getReason());
        request.setChildPolicy(terminateParameters.getChildPolicy());
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.terminateWorkflowExecution(request);
    }
}

