/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.BlockCallerPolicy;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.SuspendableSemaphore;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.Throttler;
import com.amazonaws.services.simpleworkflow.model.DomainAlreadyExistsException;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GenericWorker<T>
implements WorkerBase {
    private static final Log log = LogFactory.getLog(GenericWorker.class);
    protected static final int MAX_IDENTITY_LENGTH = 256;
    protected AmazonSimpleWorkflow service;
    protected String domain;
    protected boolean registerDomain;
    protected long domainRetentionPeriodInDays = -1L;
    private String taskListToPoll;
    private int maximumPollRateIntervalMilliseconds = 1000;
    private double maximumPollRatePerSecond;
    private double pollBackoffCoefficient = 2.0;
    private long pollBackoffInitialInterval = 100L;
    private long pollBackoffMaximumInterval = 60000L;
    private boolean disableTypeRegistrationOnStart;
    private boolean disableServiceShutdownOnStop;
    private boolean allowCoreThreadTimeOut;
    private boolean suspended;
    private final AtomicBoolean startRequested = new AtomicBoolean();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private ScheduledExecutorService pollingExecutor;
    private ThreadPoolExecutor workerExecutor;
    private String identity = ManagementFactory.getRuntimeMXBean().getName();
    private int pollThreadCount = 1;
    protected int executeThreadCount = 100;
    private BackoffThrottler pollBackoffThrottler;
    private Throttler pollRateThrottler;
    protected Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error((Object)("Failure in thread " + t.getName()), e);
        }
    };
    private TaskPoller<T> poller;
    private SimpleWorkflowClientConfig clientConfig;

    public GenericWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this(service, domain, taskListToPoll, null);
    }

    public GenericWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll, SimpleWorkflowClientConfig clientConfig) {
        this();
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
        this.clientConfig = clientConfig;
    }

    public GenericWorker() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        int length = Math.min(this.identity.length(), 256);
        this.identity = this.identity.substring(0, length);
    }

    @Override
    public void start() {
        if (log.isInfoEnabled()) {
            log.info((Object)("start: " + this));
        }
        if (this.shutdownRequested.get()) {
            throw new IllegalStateException("Shutdown Requested. Not restartable.");
        }
        if (!this.startRequested.compareAndSet(false, true)) {
            return;
        }
        this.checkRequiredProperty(this.service, "service");
        this.checkRequiredProperty(this.domain, "domain");
        this.checkRequiredProperty(this.taskListToPoll, "taskListToPoll");
        this.checkRequiredProperties();
        if (this.registerDomain) {
            this.registerDomain();
        }
        if (!this.disableTypeRegistrationOnStart) {
            this.registerTypesToPoll();
        }
        if (this.maximumPollRatePerSecond > 0.0) {
            this.pollRateThrottler = new Throttler("pollRateThrottler " + this.taskListToPoll, this.maximumPollRatePerSecond, this.maximumPollRateIntervalMilliseconds);
        }
        this.poller = this.createPoller();
        if (this.suspended) {
            this.poller.suspend();
        }
        this.pollBackoffThrottler = new BackoffThrottler(this.pollBackoffInitialInterval, this.pollBackoffMaximumInterval, this.pollBackoffCoefficient);
        this.workerExecutor = new ThreadPoolExecutor(this.executeThreadCount, this.executeThreadCount, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new BlockCallerPolicy());
        this.workerExecutor.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        ExecutorThreadFactory pollExecutorThreadFactory = this.getExecutorThreadFactory("Worker");
        this.workerExecutor.setThreadFactory(pollExecutorThreadFactory);
        this.pollingExecutor = new ScheduledThreadPoolExecutor(this.pollThreadCount, this.getExecutorThreadFactory("Poller"));
        for (int i = 0; i < this.pollThreadCount; ++i) {
            this.pollingExecutor.scheduleWithFixedDelay(new PollingTask(this.poller), 0L, 1L, TimeUnit.NANOSECONDS);
        }
    }

    private ExecutorThreadFactory getExecutorThreadFactory(String type) {
        return new ExecutorThreadFactory(this.getPollThreadNamePrefix() + " " + type);
    }

    protected abstract String getPollThreadNamePrefix();

    protected abstract TaskPoller<T> createPoller();

    protected abstract void checkRequiredProperties();

    private void registerDomain() {
        block3: {
            if (this.domainRetentionPeriodInDays == -1L) {
                throw new IllegalStateException("required property domainRetentionPeriodInDays is not set");
            }
            try {
                RegisterDomainRequest request = new RegisterDomainRequest().withName(this.domain).withWorkflowExecutionRetentionPeriodInDays(String.valueOf(this.domainRetentionPeriodInDays));
                RequestTimeoutHelper.overrideControlPlaneRequestTimeout((AmazonWebServiceRequest)request, this.clientConfig);
                this.service.registerDomain(request);
            }
            catch (DomainAlreadyExistsException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Domain is already registered: " + this.domain));
            }
        }
    }

    protected void checkRequiredProperty(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException("required property " + name + " is not set");
        }
    }

    protected void checkStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
    }

    private boolean isStarted() {
        return this.startRequested.get();
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"shutdown");
        }
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        if (!this.isStarted()) {
            return;
        }
        if (!this.disableServiceShutdownOnStop) {
            this.service.shutdown();
        }
        this.pollingExecutor.shutdown();
        this.workerExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info((Object)"shutdownNow");
        }
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        if (!this.isStarted()) {
            return;
        }
        if (!this.disableServiceShutdownOnStop) {
            this.service.shutdown();
        }
        this.pollingExecutor.shutdownNow();
        this.workerExecutor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean terminated = this.pollingExecutor.awaitTermination(timeout, unit);
        long elapsed = System.currentTimeMillis() - start;
        long left = TimeUnit.MILLISECONDS.convert(timeout, unit) - elapsed;
        return terminated &= this.workerExecutor.awaitTermination(left, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean gracefulShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.setDisableServiceShutdownOnStop(true);
        return this.shutdownAndAwaitTermination(timeout, unit);
    }

    @Override
    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long left;
        long elapsed;
        long timeoutMilliseconds = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long start = System.currentTimeMillis();
        if (this.shutdownRequested.compareAndSet(false, true)) {
            if (!this.isStarted()) {
                return true;
            }
            if (!this.disableServiceShutdownOnStop) {
                this.service.shutdown();
            }
            this.pollingExecutor.shutdown();
            this.pollingExecutor.awaitTermination(timeout, unit);
            this.workerExecutor.shutdown();
            elapsed = System.currentTimeMillis() - start;
            left = timeoutMilliseconds - elapsed;
            this.workerExecutor.awaitTermination(left, unit);
        }
        elapsed = System.currentTimeMillis() - start;
        left = timeoutMilliseconds - elapsed;
        return this.awaitTermination(left, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isRunning() {
        return this.isStarted() && !this.pollingExecutor.isTerminated() && !this.workerExecutor.isTerminated();
    }

    @Override
    public void suspendPolling() {
        if (log.isInfoEnabled()) {
            log.info((Object)"suspendPolling");
        }
        this.suspended = true;
        if (this.poller != null) {
            this.poller.suspend();
        }
    }

    @Override
    public void resumePolling() {
        if (log.isInfoEnabled()) {
            log.info((Object)"resumePolling");
        }
        this.suspended = false;
        if (this.poller != null) {
            this.poller.resume();
        }
    }

    @Override
    public boolean isPollingSuspended() {
        if (this.poller != null) {
            return this.poller.isSuspended();
        }
        return this.suspended;
    }

    @Override
    public void setPollingSuspended(boolean flag) {
        if (flag) {
            this.suspendPolling();
        } else {
            this.resumePolling();
        }
    }

    @Override
    public void setRegisterDomain(boolean registerDomain) {
        this.registerDomain = registerDomain;
    }

    @Override
    public void setPollBackoffInitialInterval(long backoffInitialInterval) {
        if (backoffInitialInterval < 0L) {
            throw new IllegalArgumentException("expected value should be positive or 0: " + backoffInitialInterval);
        }
        this.pollBackoffInitialInterval = backoffInitialInterval;
    }

    @Override
    public void setPollBackoffMaximumInterval(long backoffMaximumInterval) {
        if (backoffMaximumInterval <= 0L) {
            throw new IllegalArgumentException("expected value should be positive: " + backoffMaximumInterval);
        }
        this.pollBackoffMaximumInterval = backoffMaximumInterval;
    }

    @Override
    public void setDisableServiceShutdownOnStop(boolean disableServiceShutdownOnStop) {
        this.disableServiceShutdownOnStop = disableServiceShutdownOnStop;
    }

    @Override
    public void setPollBackoffCoefficient(double backoffCoefficient) {
        if (backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("expected value should be bigger or equal to 1.0: " + backoffCoefficient);
        }
        this.pollBackoffCoefficient = backoffCoefficient;
    }

    @Override
    public void setPollThreadCount(int threadCount) {
        this.checkStarted();
        this.pollThreadCount = threadCount;
        if (this.executeThreadCount < threadCount) {
            this.executeThreadCount = threadCount;
        }
    }

    @Override
    public void setExecuteThreadCount(int threadCount) {
        this.checkStarted();
        this.executeThreadCount = threadCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[service=" + this.service + ", domain=" + this.domain + ", taskListToPoll=" + this.taskListToPoll + ", identity=" + this.identity + ", backoffInitialInterval=" + this.pollBackoffInitialInterval + ", backoffMaximumInterval=" + this.pollBackoffMaximumInterval + ", backoffCoefficient=" + this.pollBackoffCoefficient + "]";
    }

    protected static ExponentialRetryParameters getRegisterTypeThrottledRetryParameters() {
        ExponentialRetryParameters retryParameters = new ExponentialRetryParameters();
        retryParameters.setBackoffCoefficient(2.0);
        retryParameters.setExpirationInterval(TimeUnit.MINUTES.toMillis(10L));
        retryParameters.setInitialInterval(TimeUnit.SECONDS.toMillis(3L));
        retryParameters.setMaximumRetries(29);
        retryParameters.setMaximumRetryInterval(TimeUnit.SECONDS.toMillis(20L));
        retryParameters.setMinimumRetries(1);
        return retryParameters;
    }

    @Override
    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.service = service;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean isRegisterDomain() {
        return this.registerDomain;
    }

    @Override
    public long getDomainRetentionPeriodInDays() {
        return this.domainRetentionPeriodInDays;
    }

    @Override
    public void setDomainRetentionPeriodInDays(long domainRetentionPeriodInDays) {
        this.domainRetentionPeriodInDays = domainRetentionPeriodInDays;
    }

    @Override
    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String taskListToPoll) {
        this.taskListToPoll = taskListToPoll;
    }

    @Override
    public int getMaximumPollRateIntervalMilliseconds() {
        return this.maximumPollRateIntervalMilliseconds;
    }

    @Override
    public void setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
        this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
    }

    @Override
    public double getMaximumPollRatePerSecond() {
        return this.maximumPollRatePerSecond;
    }

    @Override
    public void setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
        this.maximumPollRatePerSecond = maximumPollRatePerSecond;
    }

    @Override
    public double getPollBackoffCoefficient() {
        return this.pollBackoffCoefficient;
    }

    @Override
    public long getPollBackoffInitialInterval() {
        return this.pollBackoffInitialInterval;
    }

    @Override
    public long getPollBackoffMaximumInterval() {
        return this.pollBackoffMaximumInterval;
    }

    @Override
    public boolean isDisableTypeRegistrationOnStart() {
        return this.disableTypeRegistrationOnStart;
    }

    @Override
    public void setDisableTypeRegistrationOnStart(boolean disableTypeRegistrationOnStart) {
        this.disableTypeRegistrationOnStart = disableTypeRegistrationOnStart;
    }

    @Override
    public boolean isDisableServiceShutdownOnStop() {
        return this.disableServiceShutdownOnStop;
    }

    @Override
    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @Override
    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public int getPollThreadCount() {
        return this.pollThreadCount;
    }

    @Override
    public int getExecuteThreadCount() {
        return this.executeThreadCount;
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public SimpleWorkflowClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(SimpleWorkflowClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    private class ExecuteTask
    implements Runnable {
        private final TaskPoller<T> poller;
        private final T task;
        private final SuspendableSemaphore pollingSemaphore;

        @Override
        public void run() {
            try {
                log.debug((Object)"execute task begin");
                this.poller.execute(this.task);
                GenericWorker.this.pollBackoffThrottler.success();
                log.debug((Object)"execute task end");
            }
            catch (Throwable e) {
                GenericWorker.this.pollBackoffThrottler.failure();
                if (!(e.getCause() instanceof InterruptedException)) {
                    GenericWorker.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
                }
            }
            finally {
                if (this.pollingSemaphore != null) {
                    this.pollingSemaphore.release();
                }
            }
        }

        public ExecuteTask(TaskPoller<T> poller, T task, SuspendableSemaphore pollingSemaphore) {
            this.poller = poller;
            this.task = task;
            this.pollingSemaphore = pollingSemaphore;
        }
    }

    private class PollingTask
    implements Runnable {
        private final TaskPoller<T> poller;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    log.debug((Object)"poll task begin");
                    if (GenericWorker.this.pollingExecutor.isShutdown() || GenericWorker.this.workerExecutor.isShutdown()) {
                        return;
                    }
                    int availableWorkers = GenericWorker.this.workerExecutor.getMaximumPoolSize() - GenericWorker.this.workerExecutor.getActiveCount();
                    if (availableWorkers < 1) {
                        log.debug((Object)"no available workers");
                        return;
                    }
                    GenericWorker.this.pollBackoffThrottler.throttle();
                    if (GenericWorker.this.pollingExecutor.isShutdown() || GenericWorker.this.workerExecutor.isShutdown()) {
                        return;
                    }
                    if (GenericWorker.this.pollRateThrottler != null) {
                        GenericWorker.this.pollRateThrottler.throttle();
                    }
                    if (GenericWorker.this.pollingExecutor.isShutdown() || GenericWorker.this.workerExecutor.isShutdown()) {
                        return;
                    }
                    boolean semaphoreNeedsRelease = false;
                    SuspendableSemaphore pollingSemaphore = this.poller.getPollingSemaphore();
                    try {
                        if (pollingSemaphore != null) {
                            pollingSemaphore.acquire();
                        }
                        semaphoreNeedsRelease = true;
                        Object task = this.poller.poll();
                        if (task == null) {
                            log.debug((Object)"no work returned");
                            return;
                        }
                        semaphoreNeedsRelease = false;
                        try {
                            GenericWorker.this.workerExecutor.execute(new ExecuteTask(this.poller, task, pollingSemaphore));
                            log.debug((Object)"poll task end");
                            continue;
                        }
                        catch (Exception e) {
                            semaphoreNeedsRelease = true;
                            throw e;
                        }
                        catch (Error e) {
                            semaphoreNeedsRelease = true;
                            throw e;
                        }
                    }
                    finally {
                        if (pollingSemaphore == null || !semaphoreNeedsRelease) continue;
                        pollingSemaphore.release();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                GenericWorker.this.pollBackoffThrottler.failure();
                if (!(e.getCause() instanceof InterruptedException)) {
                    GenericWorker.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
                }
                return;
            }
        }

        public PollingTask(TaskPoller<T> poller) {
            this.poller = poller;
        }
    }

    class ExecutorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadIndex = new AtomicInteger();
        private final String threadPrefix;

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setName(this.threadPrefix + this.threadIndex.incrementAndGet());
            result.setUncaughtExceptionHandler(GenericWorker.this.uncaughtExceptionHandler);
            return result;
        }

        public ExecutorThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
        }
    }
}

