/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.ActivityTaskTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.ScheduleActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ExecuteActivityParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskCanceledEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskCompletedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskTimedOutEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;

class GenericActivityClientImpl
implements GenericActivityClient {
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<String, ActivityType>> scheduledActivities = new HashMap<String, OpenRequestInfo<String, ActivityType>>();

    public GenericActivityClientImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public Promise<String> scheduleActivityTask(ExecuteActivityParameters parameters) {
        final OpenRequestInfo context = new OpenRequestInfo(parameters.getActivityType());
        final ScheduleActivityTaskDecisionAttributes attributes = new ScheduleActivityTaskDecisionAttributes();
        attributes.setActivityType(parameters.getActivityType());
        attributes.setInput(parameters.getInput());
        attributes.setHeartbeatTimeout(FlowHelpers.secondsToDuration(parameters.getHeartbeatTimeoutSeconds()));
        attributes.setScheduleToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getScheduleToCloseTimeoutSeconds()));
        attributes.setScheduleToStartTimeout(FlowHelpers.secondsToDuration(parameters.getScheduleToStartTimeoutSeconds()));
        attributes.setStartToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getStartToCloseTimeoutSeconds()));
        attributes.setTaskPriority(FlowHelpers.taskPriorityToString(parameters.getTaskPriority()));
        String activityId = parameters.getActivityId();
        if (activityId == null) {
            activityId = String.valueOf(this.decisions.getNextId());
        }
        attributes.setActivityId(activityId);
        attributes.setControl(parameters.getControl());
        String taskList = parameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            attributes.setTaskList(new TaskList().withName(taskList));
        }
        String taskName = "activityId=" + activityId + ", activityType=" + attributes.getActivityType();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                GenericActivityClientImpl.this.decisions.scheduleActivityTask(attributes);
                context.setCompletionHandle(handle);
                GenericActivityClientImpl.this.scheduledActivities.put(attributes.getActivityId(), context);
                return new ActivityCancellationHandler(attributes.getActivityId(), handle);
            }
        }.setName(taskName);
        context.setResultDescription("scheduleActivityTask " + taskName);
        return context.getResult();
    }

    @Override
    public Promise<String> scheduleActivityTask(final String activity, final String version, final Promise<String> input) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(GenericActivityClientImpl.this.scheduleActivityTask(activity, version, (String)input.get()));
            }
        };
        return result;
    }

    @Override
    public Promise<String> scheduleActivityTask(String activity, String version, String input) {
        ExecuteActivityParameters parameters = new ExecuteActivityParameters();
        parameters.setActivityType(new ActivityType().withName(activity).withVersion(version));
        parameters.setInput(input);
        return this.scheduleActivityTask(parameters);
    }

    void handleActivityTaskStarted(ActivityTaskStartedEventAttributes attributes) {
    }

    void handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.getActivityTaskCanceledEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskCanceled(event)) {
            CancellationException e = new CancellationException();
            OpenRequestInfo<String, ActivityType> scheduled = this.scheduledActivities.remove(activityId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                completionHandle.fail(e);
            }
        }
    }

    void handleScheduleActivityTaskFailed(HistoryEvent event) {
        ScheduleActivityTaskFailedEventAttributes attributes = event.getScheduleActivityTaskFailedEventAttributes();
        String activityId = attributes.getActivityId();
        OpenRequestInfo<String, ActivityType> scheduled = this.scheduledActivities.remove(activityId);
        if (this.decisions.handleScheduleActivityTaskFailed(event)) {
            String cause = attributes.getCause();
            ScheduleActivityTaskFailedException failure = new ScheduleActivityTaskFailedException(event.getEventId(), attributes.getActivityType(), activityId, cause);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleActivityTaskCompleted(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskCompletedEventAttributes attributes = event.getActivityTaskCompletedEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String result = attributes.getResult();
            scheduled.getResult().set(result);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.complete();
        }
    }

    void handleActivityTaskFailed(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskFailedEventAttributes attributes = event.getActivityTaskFailedEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String reason = attributes.getReason();
            String details = attributes.getDetails();
            ActivityTaskFailedException failure = new ActivityTaskFailedException(event.getEventId(), scheduled.getUserContext(), activityId, reason, details);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleActivityTaskTimedOut(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskTimedOutEventAttributes attributes = event.getActivityTaskTimedOutEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String timeoutType = attributes.getTimeoutType();
            String details = attributes.getDetails();
            ActivityTaskTimedOutException failure = new ActivityTaskTimedOutException(event.getEventId(), scheduled.getUserContext(), activityId, timeoutType, details);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    private final class ActivityCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String activityId;
        private final ExternalTaskCompletionHandle handle;

        private ActivityCancellationHandler(String activityId, ExternalTaskCompletionHandle handle) {
            this.activityId = activityId;
            this.handle = handle;
        }

        @Override
        public void handleCancellation(Throwable cause) {
            GenericActivityClientImpl.this.decisions.requestCancelActivityTask(this.activityId, new Runnable(){

                @Override
                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)GenericActivityClientImpl.this.scheduledActivities.remove(ActivityCancellationHandler.this.activityId);
                    if (scheduled == null) {
                        throw new IllegalArgumentException("Activity \"" + ActivityCancellationHandler.this.activityId + "\" wasn't scheduled");
                    }
                    ActivityCancellationHandler.this.handle.complete();
                }
            });
        }
    }
}

