/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.SuspendableSemaphore;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecisionTaskPoller
implements TaskPoller<DecisionTaskIterator> {
    private static final Log log = LogFactory.getLog(DecisionTaskPoller.class);
    private static final Log decisionsLog = LogFactory.getLog((String)(DecisionTaskPoller.class.getName() + ".decisions"));
    private AmazonSimpleWorkflow service;
    private String domain;
    private String taskListToPoll;
    private String identity;
    private boolean validated;
    private DecisionTaskHandler decisionTaskHandler;
    private boolean suspended;
    private final Lock lock = new ReentrantLock();
    private final Condition suspentionCondition = this.lock.newCondition();
    private SimpleWorkflowClientConfig config;

    public DecisionTaskPoller() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
    }

    public DecisionTaskPoller(AmazonSimpleWorkflow service, String domain, String taskListToPoll, DecisionTaskHandler decisionTaskHandler) {
        this(service, domain, taskListToPoll, decisionTaskHandler, null);
    }

    public DecisionTaskPoller(AmazonSimpleWorkflow service, String domain, String taskListToPoll, DecisionTaskHandler decisionTaskHandler, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
        this.decisionTaskHandler = decisionTaskHandler;
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        this.config = config;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.validated = false;
        this.identity = identity;
    }

    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public String getDomain() {
        return this.domain;
    }

    public DecisionTaskHandler getDecisionTaskHandler() {
        return this.decisionTaskHandler;
    }

    public void setDecisionTaskHandler(DecisionTaskHandler decisionTaskHandler) {
        this.validated = false;
        this.decisionTaskHandler = decisionTaskHandler;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.validated = false;
        this.service = service;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String pollTaskList) {
        this.taskListToPoll = pollTaskList;
    }

    public void setSimpleWorkflowClientConfig(SimpleWorkflowClientConfig config) {
        this.config = config;
    }

    public SimpleWorkflowClientConfig getSimpleWorkflowClientConfig() {
        return this.config;
    }

    private DecisionTask poll(String nextResultToken) {
        this.validate();
        PollForDecisionTaskRequest pollRequest = new PollForDecisionTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.identity);
        pollRequest.setNextPageToken(nextResultToken);
        pollRequest.setTaskList(new TaskList().withName(this.taskListToPoll));
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        RequestTimeoutHelper.overridePollRequestTimeout((AmazonWebServiceRequest)pollRequest, this.config);
        DecisionTask result = this.service.pollForDecisionTask(pollRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request returned decision task: workflowType=" + result.getWorkflowType() + ", workflowExecution=" + result.getWorkflowExecution() + ", startedEventId=" + result.getStartedEventId() + ", previousStartedEventId=" + result.getPreviousStartedEventId()));
        }
        if (result == null || result.getTaskToken() == null) {
            return null;
        }
        return result;
    }

    @Override
    public DecisionTaskIterator poll() throws InterruptedException {
        this.waitIfSuspended();
        DecisionTaskIterator tasks = new DecisionTaskIterator();
        if (!tasks.hasNext()) {
            return null;
        }
        return tasks;
    }

    @Override
    public void execute(DecisionTaskIterator tasks) throws Exception {
        RespondDecisionTaskCompletedRequest taskCompletedRequest = null;
        try {
            taskCompletedRequest = this.decisionTaskHandler.handleDecisionTask(tasks);
            if (decisionsLog.isTraceEnabled()) {
                decisionsLog.trace((Object)WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.getDecisions()));
            }
            RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)taskCompletedRequest, this.config);
            this.service.respondDecisionTaskCompleted(taskCompletedRequest);
        }
        catch (Error e) {
            DecisionTask firstTask = tasks.getFirstDecisionTask();
            if (firstTask != null && log.isWarnEnabled()) {
                log.warn((Object)("DecisionTask failure: taskId= " + firstTask.getStartedEventId() + ", workflowExecution=" + firstTask.getWorkflowExecution()), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            DecisionTask firstTask = tasks.getFirstDecisionTask();
            if (firstTask != null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("DecisionTask failure: taskId= " + firstTask.getStartedEventId() + ", workflowExecution=" + firstTask.getWorkflowExecution()), (Throwable)e);
                }
                if (log.isDebugEnabled() && firstTask.getEvents() != null) {
                    log.debug((Object)("Failed taskId=" + firstTask.getStartedEventId() + " history: " + WorkflowExecutionUtils.prettyPrintHistory(firstTask.getEvents(), true)));
                }
            }
            if (taskCompletedRequest != null && decisionsLog.isWarnEnabled()) {
                decisionsLog.warn((Object)("Failed taskId=" + firstTask.getStartedEventId() + " decisions=" + WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.getDecisions())));
            }
            throw e;
        }
    }

    private void waitIfSuspended() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.suspended) {
                this.suspentionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validate() throws IllegalStateException {
        if (this.validated) {
            return;
        }
        this.checkFieldSet("decisionTaskHandler", this.decisionTaskHandler);
        this.checkFieldSet("service", this.service);
        this.checkFieldSet("identity", this.identity);
        this.validated = true;
    }

    private void checkFieldSet(String fieldName, Object fieldValue) throws IllegalStateException {
        if (fieldValue == null) {
            throw new IllegalStateException("Required field " + fieldName + " is not set");
        }
    }

    protected void checkFieldNotNegative(String fieldName, long fieldValue) throws IllegalStateException {
        if (fieldValue < 0L) {
            throw new IllegalStateException("Field " + fieldName + " is negative");
        }
    }

    @Override
    public void suspend() {
        this.lock.lock();
        try {
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resume() {
        this.lock.lock();
        try {
            this.suspended = false;
            this.suspentionCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SuspendableSemaphore getPollingSemaphore() {
        return null;
    }

    protected class DecisionTaskIterator
    implements Iterator<DecisionTask> {
        private final DecisionTask firstDecisionTask;
        private DecisionTask next;
        final long startedTime = System.nanoTime();
        int pages = 1;

        public DecisionTaskIterator() {
            this.next = this.firstDecisionTask = DecisionTaskPoller.this.poll(null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DecisionTask next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("hasNext() == false");
            }
            DecisionTask result = this.next;
            if (this.next.getNextPageToken() == null) {
                this.next = null;
                if (log.isDebugEnabled()) {
                    long iteratorCompletionTime = System.nanoTime();
                    log.debug((Object)String.format("Finished paginating request. NumPages [%d]. Duration: [%dms]. Domain: [%s]. TaskList [%s].", this.pages, Duration.ofNanos(iteratorCompletionTime - this.startedTime).toMillis(), DecisionTaskPoller.this.domain, DecisionTaskPoller.this.taskListToPoll));
                }
            } else {
                try {
                    this.next = DecisionTaskPoller.this.poll(this.next.getNextPageToken());
                    ++this.pages;
                }
                catch (Exception e) {
                    throw new Error("Failure getting next page of history events.", e);
                }
                if (this.firstDecisionTask != result) {
                    this.firstDecisionTask.setEvents(null);
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public DecisionTask getFirstDecisionTask() {
            return this.firstDecisionTask;
        }
    }
}

