/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTarget;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionDecisionAttributes;

class ChildWorkflowDecisionStateMachine
extends DecisionStateMachineBase {
    private final StartChildWorkflowExecutionDecisionAttributes startAttributes;
    private String workflowId;

    public ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes) {
        super(id);
        this.startAttributes = startAttributes;
        this.workflowId = startAttributes.getWorkflowId();
    }

    ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes, DecisionState state) {
        super(id, state);
        this.startAttributes = startAttributes;
        this.workflowId = startAttributes.getWorkflowId();
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartChildWorkflowExecutionDecision();
            }
            case CANCELED_AFTER_STARTED: {
                return this.createRequestCancelExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: {
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        String actualWorkflowId = event.getStartChildWorkflowExecutionInitiatedEventAttributes().getWorkflowId();
        if (!this.workflowId.equals(actualWorkflowId)) {
            this.workflowId = actualWorkflowId;
            this.id = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId);
        }
        super.handleInitiatedEvent(event);
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        String actualWorkflowId = event.getStartChildWorkflowExecutionFailedEventAttributes().getWorkflowId();
        if (!this.workflowId.equals(actualWorkflowId)) {
            this.workflowId = actualWorkflowId;
            this.id = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId);
        }
        super.handleInitiationFailedEvent(event);
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        this.stateHistory.add("handleStartedEvent");
        switch (this.state) {
            case INITIATED: {
                this.state = DecisionState.STARTED;
                break;
            }
            case CANCELED_AFTER_INITIATED: {
                this.state = DecisionState.CANCELED_AFTER_STARTED;
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.STARTED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    @Override
    public void cancel(Runnable immediateCancellationCallback) {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("cancel");
                this.state = DecisionState.CANCELED_AFTER_STARTED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.cancel(immediateCancellationCallback);
            }
        }
    }

    @Override
    public void handleCancellationEvent() {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("handleCancellationEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationEvent();
            }
        }
    }

    @Override
    public void handleCompletionEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: 
            case STARTED: 
            case COMPLETED: {
                this.stateHistory.add("handleCompletionEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCompletionEvent();
            }
        }
    }

    private Decision createRequestCancelExternalWorkflowExecutionDecision() {
        RequestCancelExternalWorkflowExecutionDecisionAttributes tryCancel = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
        tryCancel.setWorkflowId(this.workflowId);
        Decision decision = new Decision();
        decision.setRequestCancelExternalWorkflowExecutionDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.RequestCancelExternalWorkflowExecution.toString());
        return decision;
    }

    private Decision createStartChildWorkflowExecutionDecision() {
        Decision decision = new Decision();
        decision.setStartChildWorkflowExecutionDecisionAttributes(this.startAttributes);
        decision.setDecisionType(DecisionType.StartChildWorkflowExecution.toString());
        return decision;
    }
}

