/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import java.util.concurrent.atomic.AtomicLong;

public class BackoffThrottler {
    protected final long initialSleep;
    protected final long maxSleep;
    protected final double backoffCoefficient;
    protected final AtomicLong failureCount = new AtomicLong();

    public BackoffThrottler(long initialSleep, long maxSleep, double backoffCoefficient) {
        this.initialSleep = initialSleep;
        this.maxSleep = maxSleep;
        this.backoffCoefficient = backoffCoefficient;
    }

    protected long calculateSleepTime() {
        double sleepMillis = Math.pow(this.backoffCoefficient, this.failureCount.get() - 1L) * (double)this.initialSleep;
        return Math.min((long)sleepMillis, this.maxSleep);
    }

    public void throttle() throws InterruptedException {
        if (this.failureCount.get() > 0L) {
            Thread.sleep(this.calculateSleepTime());
        }
    }

    public void success() {
        this.failureCount.set(0L);
    }

    public void failure() {
        this.failureCount.incrementAndGet();
    }
}

