/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DefaultChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeComponentImplementationVersion;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeImplementationOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncDecisionTaskHandler
extends DecisionTaskHandler {
    static final String COMPONENT_VERSION_MARKER = "*component_version*";
    static final String COMPONENT_VERSION_RECORD_SEPARATOR = "\n";
    static final String COMPONENT_VERSION_SEPARATOR = "\t";
    static final String COMPONENT_VERSION_SEPARATORS_PATTERN = "\n|\t";
    private static final Log log = LogFactory.getLog(AsyncDecisionTaskHandler.class);
    private static final Log asyncThreadDumpLog = LogFactory.getLog((String)(AsyncDecisionTaskHandler.class.getName() + ".waitingTasksStacks"));
    private final WorkflowDefinitionFactoryFactory definitionFactoryFactory;
    private final ChildWorkflowIdHandler childWorkflowIdHandler;
    private final boolean skipFailedCheck;

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory) {
        this(definitionFactoryFactory, false);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler) {
        this(definitionFactoryFactory, false, childWorkflowIdHandler);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, boolean skipFailedCheck) {
        this(definitionFactoryFactory, skipFailedCheck, null);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, boolean skipFailedCheck, ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.definitionFactoryFactory = definitionFactoryFactory;
        this.skipFailedCheck = skipFailedCheck;
        this.childWorkflowIdHandler = childWorkflowIdHandler != null ? childWorkflowIdHandler : new DefaultChildWorkflowIdHandler();
    }

    @Override
    public RespondDecisionTaskCompletedRequest handleDecisionTask(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        List<Decision> decisions = decisionsHelper.getDecisions();
        DecisionTask decisionTask = historyHelper.getDecisionTask();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask taskId=" + decisionTask.getStartedEventId() + ", taskToken=" + decisionTask.getTaskToken() + " completed with " + decisions.size() + " new decisions"));
        }
        if (decisions.size() == 0 && asyncThreadDumpLog.isTraceEnabled()) {
            asyncThreadDumpLog.trace((Object)("Empty decision list with the following waiting tasks:\n" + decider.getAsynchronousThreadDumpAsString()));
        }
        RespondDecisionTaskCompletedRequest completedRequest = new RespondDecisionTaskCompletedRequest();
        completedRequest.setTaskToken(decisionTask.getTaskToken());
        completedRequest.setDecisions(decisions);
        String contextData = decisionsHelper.getWorkflowContextDataToReturn();
        ComponentVersions componentVersions = historyHelper.getComponentVersions();
        Map<String, Integer> versionsToSave = componentVersions.getVersionsToSave();
        String executionContext = this.getExecutionContext(contextData, versionsToSave);
        if (historyHelper.getWorkflowContextData() == null || !historyHelper.getWorkflowContextData().equals(executionContext)) {
            completedRequest.setExecutionContext(executionContext);
        }
        return completedRequest;
    }

    private String getExecutionContext(String contextData, Map<String, Integer> componentVersions) {
        int versionsSize = componentVersions.size();
        if (versionsSize == 0 && contextData == null) {
            return null;
        }
        StringBuilder executionContext = new StringBuilder();
        if (versionsSize > 0) {
            executionContext.append(COMPONENT_VERSION_MARKER);
            executionContext.append(COMPONENT_VERSION_SEPARATOR);
            executionContext.append(versionsSize);
            executionContext.append(COMPONENT_VERSION_RECORD_SEPARATOR);
            for (Map.Entry<String, Integer> version : componentVersions.entrySet()) {
                executionContext.append(version.getKey());
                executionContext.append(COMPONENT_VERSION_SEPARATOR);
                executionContext.append(version.getValue());
                executionContext.append(COMPONENT_VERSION_RECORD_SEPARATOR);
            }
        }
        executionContext.append(contextData);
        return executionContext.toString();
    }

    @Override
    public WorkflowDefinition loadWorkflowThroughReplay(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        if (!this.skipFailedCheck && decisionsHelper.isWorkflowFailed()) {
            throw new IllegalStateException("Cannot load failed workflow", decisionsHelper.getWorkflowFailureCause());
        }
        return decider.getWorkflowDefinition();
    }

    @Override
    public List<AsyncTaskInfo> getAsynchronousThreadDump(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDump();
    }

    @Override
    public String getAsynchronousThreadDumpAsString(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDumpAsString();
    }

    private AsyncDecider createDecider(HistoryHelper historyHelper) throws Exception {
        WorkflowDefinitionFactory workflowDefinitionFactory;
        DecisionTask decisionTask = historyHelper.getDecisionTask();
        WorkflowType workflowType = decisionTask.getWorkflowType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask received: taskId=" + decisionTask.getStartedEventId() + ", taskToken=" + decisionTask.getTaskToken() + ", workflowExecution=" + decisionTask.getWorkflowExecution()));
        }
        if ((workflowDefinitionFactory = this.definitionFactoryFactory.getWorkflowDefinitionFactory(workflowType)) == null) {
            log.error((Object)("Received decision task for workflow type not configured with a worker: workflowType=" + decisionTask.getWorkflowType() + ", taskToken=" + decisionTask.getTaskToken() + ", workflowExecution=" + decisionTask.getWorkflowExecution()));
            Iterable<WorkflowType> typesToRegister = this.definitionFactoryFactory.getWorkflowTypesToRegister();
            StringBuilder types = new StringBuilder();
            types.append("[");
            for (WorkflowType t : typesToRegister) {
                if (types.length() > 1) {
                    types.append(", ");
                }
                types.append(t);
            }
            types.append("]");
            throw new IncompatibleWorkflowDefinition("Workflow type \"" + workflowType + "\" is not supported by the WorkflowWorker. Possible cause is workflow type version change without changing task list name. Workflow types registered by the worker are: " + types.toString());
        }
        DecisionsHelper decisionsHelper = new DecisionsHelper(decisionTask, this.childWorkflowIdHandler);
        WorkflowTypeImplementationOptions workflowImplementationOptions = workflowDefinitionFactory.getWorkflowImplementationOptions();
        if (workflowImplementationOptions != null) {
            List<WorkflowTypeComponentImplementationVersion> implementationComponentVersions = workflowImplementationOptions.getImplementationComponentVersions();
            historyHelper.getComponentVersions().setWorkflowImplementationComponentVersions(implementationComponentVersions);
        }
        return new AsyncDecider(workflowDefinitionFactory, historyHelper, decisionsHelper);
    }
}

