/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowValueConstraint;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.retry.SynchronousRetrier;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityExecutionContextImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeCompletionRetryOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.SuspendableSemaphore;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.UnknownResourceException;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivityTaskPoller
implements TaskPoller<ActivityTask> {
    private static final Log log = LogFactory.getLog(ActivityTaskPoller.class);
    private SuspendableSemaphore pollSemaphore;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static final long SECOND = 1000L;
    private AmazonSimpleWorkflow service;
    private String domain;
    private String taskListToPoll;
    private ActivityImplementationFactory activityImplementationFactory;
    private String identity;
    private boolean initialized;
    private boolean suspended;
    private final Lock lock = new ReentrantLock();
    private final Condition suspentionCondition = this.lock.newCondition();
    private SimpleWorkflowClientConfig config;

    public ActivityTaskPoller() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        int length = Math.min(this.identity.length(), 256);
        this.identity = this.identity.substring(0, length);
    }

    public ActivityTaskPoller(AmazonSimpleWorkflow service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory) {
        this(service, domain, pollTaskList, activityImplementationFactory, null);
    }

    public ActivityTaskPoller(AmazonSimpleWorkflow service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory, SimpleWorkflowClientConfig config) {
        this();
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = pollTaskList;
        this.activityImplementationFactory = activityImplementationFactory;
        this.config = config;
    }

    public ActivityTaskPoller(AmazonSimpleWorkflow service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory, int executeThreadCount, SimpleWorkflowClientConfig config) {
        this(service, domain, pollTaskList, activityImplementationFactory, config);
        this.pollSemaphore = new SuspendableSemaphore(executeThreadCount);
    }

    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.service = service;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPollTaskList() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String taskList) {
        this.taskListToPoll = taskList;
    }

    public ActivityImplementationFactory getActivityImplementationFactory() {
        return this.activityImplementationFactory;
    }

    public void setActivityImplementationFactory(ActivityImplementationFactory activityImplementationFactory) {
        this.activityImplementationFactory = activityImplementationFactory;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private Exception wrapFailure(ActivityTask task, Throwable failure) {
        WorkflowExecution execution = task.getWorkflowExecution();
        RuntimeException e2 = new RuntimeException("Failure taskId=\"" + task.getStartedEventId() + "\" workflowExecutionRunId=\"" + execution.getRunId() + "\" workflowExecutionId=\"" + execution.getWorkflowId() + "\"", failure);
        return e2;
    }

    @Override
    public ActivityTask poll() throws InterruptedException {
        this.waitIfSuspended();
        if (!this.initialized) {
            this.checkRequiredProperty(this.service, "service");
            this.checkRequiredProperty(this.domain, "domain");
            this.checkRequiredProperty(this.taskListToPoll, "taskListToPoll");
            this.initialized = true;
        }
        PollForActivityTaskRequest pollRequest = new PollForActivityTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.identity);
        pollRequest.setTaskList(new TaskList().withName(this.taskListToPoll));
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        RequestTimeoutHelper.overridePollRequestTimeout((AmazonWebServiceRequest)pollRequest, this.config);
        ActivityTask result = this.service.pollForActivityTask(pollRequest);
        if (result == null || result.getTaskToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"poll request returned no task");
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("poll request returned " + result));
        }
        return result;
    }

    @Override
    public void execute(ActivityTask task) throws Exception {
        String output = null;
        ActivityType activityType = task.getActivityType();
        ActivityExecutionContextImpl context = new ActivityExecutionContextImpl(this.service, this.domain, task, this.config);
        ActivityTypeExecutionOptions executionOptions = null;
        try {
            ActivityImplementation activityImplementation = this.activityImplementationFactory.getActivityImplementation(activityType);
            if (activityImplementation == null) {
                Iterable<ActivityType> typesToRegister = this.activityImplementationFactory.getActivityTypesToRegister();
                StringBuilder types = new StringBuilder();
                types.append("[");
                for (ActivityType t : typesToRegister) {
                    if (types.length() > 1) {
                        types.append(", ");
                    }
                    types.append(t);
                }
                types.append("]");
                throw new ActivityFailureException("Activity type \"" + activityType + "\" is not supported by the ActivityWorker. Possible cause is activity type version change without changing task list name. Activity types registered with the worker are: " + types.toString());
            }
            executionOptions = activityImplementation.getExecutionOptions();
            output = activityImplementation.execute(context);
        }
        catch (CancellationException e) {
            this.respondActivityTaskCanceledWithRetry(task.getTaskToken(), null, executionOptions);
            return;
        }
        catch (ActivityFailureException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failure processing activity task with taskId=" + task.getStartedEventId() + ", workflowGenerationId=" + task.getWorkflowExecution().getWorkflowId() + ", activity=" + activityType + ", activityInstanceId=" + task.getActivityId()), (Throwable)e);
            }
            this.respondActivityTaskFailedWithRetry(task.getTaskToken(), e.getReason(), e.getDetails(), executionOptions);
            return;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failure processing activity task with taskId=" + task.getStartedEventId() + ", workflowGenerationId=" + task.getWorkflowExecution().getWorkflowId() + ", activity=" + activityType + ", activityInstanceId=" + task.getActivityId()), (Throwable)e);
            }
            String reason = e.getMessage();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String details = sw.toString();
            if (details.length() > FlowValueConstraint.FAILURE_DETAILS.getMaxSize()) {
                log.warn((Object)("Length of details is over maximum input length of 32768. Actual details: " + details + "when processing activity task with taskId=" + task.getStartedEventId() + ", workflowGenerationId=" + task.getWorkflowExecution().getWorkflowId() + ", activity=" + activityType + ", activityInstanceId=" + task.getActivityId()));
                details = WorkflowExecutionUtils.truncateDetails(details);
            }
            this.respondActivityTaskFailedWithRetry(task.getTaskToken(), reason, details, executionOptions);
            return;
        }
        if (executionOptions == null || !executionOptions.isManualActivityCompletion()) {
            this.respondActivityTaskCompletedWithRetry(task.getTaskToken(), output, executionOptions);
        }
    }

    private void waitIfSuspended() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.suspended) {
                this.suspentionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void suspend() {
        this.lock.lock();
        try {
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resume() {
        this.lock.lock();
        try {
            this.suspended = false;
            this.suspentionCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SuspendableSemaphore getPollingSemaphore() {
        return this.pollSemaphore;
    }

    protected void checkRequiredProperty(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException("required property " + name + " is not set");
        }
    }

    protected void respondActivityTaskFailed(String taskToken, String reason, String details) {
        RespondActivityTaskFailedRequest failedResponse = new RespondActivityTaskFailedRequest();
        failedResponse.setTaskToken(taskToken);
        failedResponse.setReason(WorkflowExecutionUtils.truncateReason(reason));
        failedResponse.setDetails(details);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)failedResponse, this.config);
        this.service.respondActivityTaskFailed(failedResponse);
    }

    protected void respondActivityTaskCanceledWithRetry(final String taskToken, final String details, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            ActivityTypeCompletionRetryOptions completionRetryOptions = executionOptions.getCompletionRetryOptions();
            retrier = this.createRetrier(completionRetryOptions);
        }
        if (retrier != null) {
            retrier.retry(new Runnable(){

                @Override
                public void run() {
                    ActivityTaskPoller.this.respondActivityTaskCanceled(taskToken, details);
                }
            });
        } else {
            this.respondActivityTaskCanceled(taskToken, details);
        }
    }

    private SynchronousRetrier createRetrier(ActivityTypeCompletionRetryOptions activityTypeCompletionRetryOptions) {
        if (activityTypeCompletionRetryOptions == null) {
            return null;
        }
        ExponentialRetryParameters retryParameters = new ExponentialRetryParameters();
        retryParameters.setBackoffCoefficient(activityTypeCompletionRetryOptions.getBackoffCoefficient());
        retryParameters.setExpirationInterval(activityTypeCompletionRetryOptions.getRetryExpirationSeconds() * 1000L);
        retryParameters.setInitialInterval(activityTypeCompletionRetryOptions.getInitialRetryIntervalSeconds() * 1000L);
        retryParameters.setMaximumRetries(activityTypeCompletionRetryOptions.getMaximumAttempts() - 1);
        retryParameters.setMaximumRetryInterval(activityTypeCompletionRetryOptions.getMaximumRetryIntervalSeconds() * 1000L);
        retryParameters.setMinimumRetries(activityTypeCompletionRetryOptions.getMinimumAttempts() - 1);
        SynchronousRetrier retrier = new SynchronousRetrier(retryParameters, UnknownResourceException.class);
        return retrier;
    }

    protected void respondActivityTaskCanceled(String taskToken, String details) {
        RespondActivityTaskCanceledRequest canceledResponse = new RespondActivityTaskCanceledRequest();
        canceledResponse.setTaskToken(taskToken);
        canceledResponse.setDetails(details);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)canceledResponse, this.config);
        this.service.respondActivityTaskCanceled(canceledResponse);
    }

    protected void respondActivityTaskCompletedWithRetry(final String taskToken, final String output, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            retrier = this.createRetrier(executionOptions.getCompletionRetryOptions());
        }
        if (retrier != null) {
            retrier.retry(new Runnable(){

                @Override
                public void run() {
                    ActivityTaskPoller.this.respondActivityTaskCompleted(taskToken, output);
                }
            });
        } else {
            this.respondActivityTaskCompleted(taskToken, output);
        }
    }

    protected void respondActivityTaskCompleted(String taskToken, String output) {
        RespondActivityTaskCompletedRequest completedResponse = new RespondActivityTaskCompletedRequest();
        completedResponse.setTaskToken(taskToken);
        completedResponse.setResult(output);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)completedResponse, this.config);
        this.service.respondActivityTaskCompleted(completedResponse);
    }

    protected void respondActivityTaskFailedWithRetry(final String taskToken, final String reason, final String details, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            retrier = this.createRetrier(executionOptions.getFailureRetryOptions());
        }
        if (retrier != null) {
            retrier.retry(new Runnable(){

                @Override
                public void run() {
                    ActivityTaskPoller.this.respondActivityTaskFailed(taskToken, reason, details);
                }
            });
        } else {
            this.respondActivityTaskFailed(taskToken, reason, details);
        }
    }
}

