/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.test;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.SignalExternalWorkflowException;
import com.amazonaws.services.simpleworkflow.flow.StartChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.core.Functor;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowReply;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.test.TestDecisionContext;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionClient;
import com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionFailedCause;
import com.amazonaws.services.simpleworkflow.model.UnknownResourceException;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;

public class TestGenericWorkflowClient
implements GenericWorkflowClient {
    private final Map<String, ChildWorkflowTryCatchFinally> workflowExecutions = new HashMap<String, ChildWorkflowTryCatchFinally>();
    protected WorkflowDefinitionFactoryFactory factoryFactory;
    protected DecisionContextProvider decisionContextProvider;

    public TestGenericWorkflowClient(WorkflowDefinitionFactoryFactory factoryFactory, DecisionContextProvider decisionContextProvider) {
        this.factoryFactory = factoryFactory;
        this.decisionContextProvider = decisionContextProvider;
    }

    public TestGenericWorkflowClient(WorkflowDefinitionFactoryFactory factoryFactory) {
        this(factoryFactory, new DecisionContextProviderImpl());
    }

    public TestGenericWorkflowClient() {
        this(null, new DecisionContextProviderImpl());
    }

    public WorkflowDefinitionFactoryFactory getFactoryFactory() {
        return this.factoryFactory;
    }

    public void setFactoryFactory(WorkflowDefinitionFactoryFactory factoryFactory) {
        this.factoryFactory = factoryFactory;
    }

    public DecisionContextProvider getDecisionContextProvider() {
        return this.decisionContextProvider;
    }

    public void setDecisionContextProvider(DecisionContextProvider decisionContextProvider) {
        this.decisionContextProvider = decisionContextProvider;
    }

    @Override
    public Promise<StartChildWorkflowReply> startChildWorkflow(StartChildWorkflowExecutionParameters parameters) {
        Settable<StartChildWorkflowReply> reply = new Settable<StartChildWorkflowReply>();
        Settable<String> result = new Settable<String>();
        this.startChildWorkflow(parameters, reply, result);
        return reply;
    }

    private void startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Settable<StartChildWorkflowReply> reply, Settable<String> result) {
        String workflowId = parameters.getWorkflowId();
        WorkflowType workflowType = parameters.getWorkflowType();
        WorkflowExecution childExecution = new WorkflowExecution();
        String runId = UUID.randomUUID().toString();
        try {
            DecisionContext parentDecisionContext = this.decisionContextProvider.getDecisionContext();
            if (workflowId == null) {
                workflowId = this.decisionContextProvider.getDecisionContext().getWorkflowClient().generateUniqueId();
            }
            childExecution.setWorkflowId(workflowId);
            childExecution.setRunId(runId);
            GenericActivityClient activityClient = parentDecisionContext.getActivityClient();
            WorkflowClock workflowClock = parentDecisionContext.getWorkflowClock();
            LambdaFunctionClient lambdaFunctionClient = parentDecisionContext.getLambdaFunctionClient();
            if (this.factoryFactory == null) {
                throw new IllegalStateException("required property factoryFactory is null");
            }
            WorkflowDefinitionFactory factory = this.factoryFactory.getWorkflowDefinitionFactory(workflowType);
            if (factory == null) {
                String cause = StartChildWorkflowExecutionFailedCause.WORKFLOW_TYPE_DOES_NOT_EXIST.toString();
                throw new StartChildWorkflowFailedException(0L, childExecution, workflowType, cause);
            }
            TestWorkflowContext workflowContext = new TestWorkflowContext();
            workflowContext.setWorkflowExecution(childExecution);
            workflowContext.setWorkflowType(parameters.getWorkflowType());
            workflowContext.setParentWorkflowExecution(parentDecisionContext.getWorkflowContext().getWorkflowExecution());
            workflowContext.setTagList(parameters.getTagList());
            workflowContext.setTaskList(parameters.getTaskList());
            TestDecisionContext context = new TestDecisionContext(activityClient, this, workflowClock, workflowContext, lambdaFunctionClient);
            WorkflowDefinition childWorkflowDefinition = factory.getWorkflowDefinition(context);
            ChildWorkflowTryCatchFinally tryCatch = new ChildWorkflowTryCatchFinally(parameters, childExecution, childWorkflowDefinition, context, result);
            workflowContext.setRootTryCatch(tryCatch);
            ChildWorkflowTryCatchFinally currentRun = this.workflowExecutions.get(workflowId);
            if (currentRun != null) {
                String cause = StartChildWorkflowExecutionFailedCause.WORKFLOW_ALREADY_RUNNING.toString();
                throw new StartChildWorkflowFailedException(0L, childExecution, workflowType, cause);
            }
            this.workflowExecutions.put(workflowId, tryCatch);
            this.continueAsNewWorkflowExecution(tryCatch, result);
        }
        catch (StartChildWorkflowFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            String cause = StartChildWorkflowExecutionFailedCause.OPEN_CHILDREN_LIMIT_EXCEEDED.toString();
            StartChildWorkflowFailedException failure = new StartChildWorkflowFailedException(0L, childExecution, workflowType, cause);
            failure.initCause(e);
            throw failure;
        }
        finally {
            reply.set(new StartChildWorkflowReplyImpl(result, workflowId, runId));
        }
    }

    private void continueAsNewWorkflowExecution(final ChildWorkflowTryCatchFinally tryCatch, final Settable<String> result) {
        final Promise<ContinueAsNewWorkflowExecutionParameters> continueAsNew = tryCatch.getContinueAsNew();
        new Task(new Promise[]{continueAsNew}){

            @Override
            protected void doExecute() throws Throwable {
                ContinueAsNewWorkflowExecutionParameters cp = (ContinueAsNewWorkflowExecutionParameters)continueAsNew.get();
                if (cp == null) {
                    return;
                }
                StartChildWorkflowExecutionParameters nextParameters = new StartChildWorkflowExecutionParameters();
                nextParameters.setInput(cp.getInput());
                WorkflowExecution previousWorkflowExecution = tryCatch.getWorkflowExecution();
                String workflowId = previousWorkflowExecution.getWorkflowId();
                nextParameters.setWorkflowId(workflowId);
                StartChildWorkflowExecutionParameters previousParameters = tryCatch.getParameters();
                nextParameters.setWorkflowType(previousParameters.getWorkflowType());
                long startToClose = cp.getExecutionStartToCloseTimeoutSeconds();
                if (startToClose == -1L) {
                    startToClose = previousParameters.getExecutionStartToCloseTimeoutSeconds();
                }
                nextParameters.setExecutionStartToCloseTimeoutSeconds(startToClose);
                long taskStartToClose = cp.getTaskStartToCloseTimeoutSeconds();
                if (taskStartToClose == -1L) {
                    taskStartToClose = previousParameters.getTaskStartToCloseTimeoutSeconds();
                }
                nextParameters.setTaskStartToCloseTimeoutSeconds(taskStartToClose);
                int taskPriority = cp.getTaskPriority();
                nextParameters.setTaskPriority(taskPriority);
                Settable reply = new Settable();
                TestGenericWorkflowClient.this.startChildWorkflow(nextParameters, reply, result);
            }
        };
    }

    @Override
    public Promise<String> startChildWorkflow(String workflow, String version, String input) {
        StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters();
        WorkflowType workflowType = new WorkflowType().withName(workflow).withVersion(version);
        parameters.setWorkflowType(workflowType);
        parameters.setInput(input);
        Settable<StartChildWorkflowReply> reply = new Settable<StartChildWorkflowReply>();
        Settable<String> result = new Settable<String>();
        this.startChildWorkflow(parameters, reply, result);
        return result;
    }

    @Override
    public Promise<String> startChildWorkflow(final String workflow, final String version, final Promise<String> input) {
        return new Functor<String>(new Promise[]{input}){

            @Override
            protected Promise<String> doExecute() throws Throwable {
                return TestGenericWorkflowClient.this.startChildWorkflow(workflow, version, (String)input.get());
            }
        };
    }

    @Override
    public Promise<Void> signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        WorkflowExecution signaledExecution = new WorkflowExecution();
        signaledExecution.setWorkflowId(signalParameters.getWorkflowId());
        signaledExecution.setRunId(signalParameters.getRunId());
        ChildWorkflowTryCatchFinally childTryCatch = this.workflowExecutions.get(signalParameters.getWorkflowId());
        if (childTryCatch == null) {
            throw new SignalExternalWorkflowException(0L, signaledExecution, "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION");
        }
        String openExecutionRunId = childTryCatch.getWorkflowExecution().getRunId();
        if (signalParameters.getRunId() != null && !openExecutionRunId.equals(signalParameters.getRunId())) {
            throw new SignalExternalWorkflowException(0L, signaledExecution, "Unknown Execution (runId doesn't match)");
        }
        childTryCatch.signalRecieved(signalParameters.getSignalName(), signalParameters.getInput());
        return Promise.Void();
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        String workflowId = execution.getWorkflowId();
        if (workflowId == null) {
            throw new IllegalArgumentException("null workflowId");
        }
        ChildWorkflowTryCatchFinally childTryCatch = this.workflowExecutions.get(workflowId);
        if (childTryCatch == null) {
            throw new UnknownResourceException("Unknown excution: " + execution.toString());
        }
        String openExecutionRunId = childTryCatch.getWorkflowExecution().getRunId();
        if (execution.getRunId() != null && !openExecutionRunId.equals(execution.getRunId())) {
            throw new UnknownResourceException("Unknown Execution (runId doesn't match)");
        }
        childTryCatch.cancel(new CancellationException());
    }

    public String getWorkflowState(WorkflowExecution execution) throws WorkflowException {
        String workflowId = execution.getWorkflowId();
        if (workflowId == null) {
            throw new IllegalArgumentException("null workflowId");
        }
        ChildWorkflowTryCatchFinally childTryCatch = this.workflowExecutions.get(workflowId);
        if (childTryCatch == null) {
            throw new UnknownResourceException(execution.toString());
        }
        String openExecutionRunId = childTryCatch.getWorkflowExecution().getRunId();
        if (execution.getRunId() != null && !openExecutionRunId.equals(execution.getRunId())) {
            throw new UnknownResourceException("Unknown Execution (runId doesn't match)");
        }
        return childTryCatch.getWorkflowState();
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters parameters) {
        DecisionContext decisionContext = this.decisionContextProvider.getDecisionContext();
        decisionContext.getWorkflowContext().setContinueAsNewOnCompletion(parameters);
    }

    @Override
    public String generateUniqueId() {
        return UUID.randomUUID().toString();
    }

    private final class ChildWorkflowTryCatchFinally
    extends TryCatchFinally {
        private final StartChildWorkflowExecutionParameters parameters;
        private final WorkflowExecution childExecution;
        private final Settable<String> result;
        private final Settable<String> executeResult = new Settable();
        private final WorkflowDefinition childWorkflowDefinition;
        private final DecisionContext childContext;
        private boolean failed;
        private final Settable<ContinueAsNewWorkflowExecutionParameters> continueAsNew = new Settable();

        private ChildWorkflowTryCatchFinally(StartChildWorkflowExecutionParameters parameters, WorkflowExecution childExecution, WorkflowDefinition childWorkflowDefinition, DecisionContext context, Settable<String> result) {
            this.parameters = parameters;
            this.childExecution = childExecution;
            this.childWorkflowDefinition = childWorkflowDefinition;
            this.childContext = context;
            this.result = result;
        }

        @Override
        protected void doTry() throws Throwable {
            this.executeResult.chain(this.childWorkflowDefinition.execute(this.parameters.getInput()));
        }

        @Override
        protected void doCatch(Throwable e) throws Throwable {
            this.failed = true;
            if (e instanceof WorkflowException) {
                WorkflowException we = (WorkflowException)e;
                throw new ChildWorkflowFailedException(0L, this.childExecution, this.parameters.getWorkflowType(), e.getMessage(), we.getDetails());
            }
            if (e instanceof CancellationException) {
                throw e;
            }
            ChildWorkflowFailedException failure = new ChildWorkflowFailedException(0L, this.childExecution, this.parameters.getWorkflowType(), e.getMessage(), "null");
            failure.initCause(e);
            throw failure;
        }

        @Override
        protected void doFinally() throws Throwable {
            if (!this.failed) {
                this.continueAsNew.set(this.childContext.getWorkflowContext().getContinueAsNewOnCompletion());
                if (this.continueAsNew.get() == null && this.executeResult.isReady()) {
                    this.result.set(this.executeResult.get());
                }
            } else {
                this.continueAsNew.set(null);
            }
            TestGenericWorkflowClient.this.workflowExecutions.remove(this.childExecution.getWorkflowId());
        }

        public void signalRecieved(final String signalName, final String details) {
            if (this.getState() != TryCatchFinally.State.TRYING) {
                throw new SignalExternalWorkflowException(0L, this.childExecution, "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION");
            }
            new Task(this, new Promise[0]){

                @Override
                protected void doExecute() throws Throwable {
                    ChildWorkflowTryCatchFinally.this.childWorkflowDefinition.signalRecieved(signalName, details);
                }
            };
        }

        public StartChildWorkflowExecutionParameters getParameters() {
            return this.parameters;
        }

        public String getWorkflowState() throws WorkflowException {
            return this.childWorkflowDefinition.getWorkflowState();
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.childExecution;
        }

        public Promise<ContinueAsNewWorkflowExecutionParameters> getContinueAsNew() {
            return this.continueAsNew;
        }
    }

    private static class StartChildWorkflowReplyImpl
    implements StartChildWorkflowReply {
        private final Settable<String> result;
        private final String runId;
        private final String workflowId;

        private StartChildWorkflowReplyImpl(Settable<String> result, String workflowId, String runId) {
            this.result = result;
            this.workflowId = workflowId;
            this.runId = runId;
        }

        @Override
        public String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public String getRunId() {
            return this.runId;
        }

        @Override
        public Promise<String> getResult() {
            return this.result;
        }
    }
}

