/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.spring;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.spring.SpringWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowWorker;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.context.SmartLifecycle;

public class SpringWorkflowWorker
implements WorkerBase,
SmartLifecycle {
    private final GenericWorkflowWorker genericWorker;
    private final SpringWorkflowDefinitionFactoryFactory factoryFactory;
    private int startPhase;
    protected long terminationTimeoutSeconds = 60L;
    private boolean disableAutoStartup;

    public SpringWorkflowWorker() {
        this(new GenericWorkflowWorker());
    }

    public SpringWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this(new GenericWorkflowWorker(service, domain, taskListToPoll));
    }

    public SpringWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll, SimpleWorkflowClientConfig config) {
        this(new GenericWorkflowWorker(service, domain, taskListToPoll, config));
    }

    public SpringWorkflowWorker(GenericWorkflowWorker genericWorker) {
        Objects.requireNonNull(genericWorker, "the workflow worker is required");
        this.genericWorker = genericWorker;
        this.factoryFactory = new SpringWorkflowDefinitionFactoryFactory();
        this.genericWorker.setWorkflowDefinitionFactoryFactory(this.factoryFactory);
    }

    @Override
    public SimpleWorkflowClientConfig getClientConfig() {
        return this.genericWorker.getClientConfig();
    }

    @Override
    public AmazonSimpleWorkflow getService() {
        return this.genericWorker.getService();
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.genericWorker.setService(service);
    }

    @Override
    public String getDomain() {
        return this.genericWorker.getDomain();
    }

    public void setDomain(String domain) {
        this.genericWorker.setDomain(domain);
    }

    @Override
    public boolean isRegisterDomain() {
        return this.genericWorker.isRegisterDomain();
    }

    @Override
    public void setRegisterDomain(boolean registerDomain) {
        this.genericWorker.setRegisterDomain(registerDomain);
    }

    @Override
    public long getDomainRetentionPeriodInDays() {
        return this.genericWorker.getDomainRetentionPeriodInDays();
    }

    @Override
    public void setDomainRetentionPeriodInDays(long domainRetentionPeriodInDays) {
        this.genericWorker.setDomainRetentionPeriodInDays(domainRetentionPeriodInDays);
    }

    @Override
    public String getTaskListToPoll() {
        return this.genericWorker.getTaskListToPoll();
    }

    public void setTaskListToPoll(String taskListToPoll) {
        this.genericWorker.setTaskListToPoll(taskListToPoll);
    }

    public DataConverter getDataConverter() {
        return this.factoryFactory.getDataConverter();
    }

    public void setDataConverter(DataConverter converter) {
        this.factoryFactory.setDataConverter(converter);
    }

    @Override
    public double getMaximumPollRatePerSecond() {
        return this.genericWorker.getMaximumPollRatePerSecond();
    }

    @Override
    public void setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
        this.genericWorker.setMaximumPollRatePerSecond(maximumPollRatePerSecond);
    }

    @Override
    public int getMaximumPollRateIntervalMilliseconds() {
        return this.genericWorker.getMaximumPollRateIntervalMilliseconds();
    }

    @Override
    public void setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
        this.genericWorker.setMaximumPollRateIntervalMilliseconds(maximumPollRateIntervalMilliseconds);
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.genericWorker.getUncaughtExceptionHandler();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.genericWorker.setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public String getIdentity() {
        return this.genericWorker.getIdentity();
    }

    @Override
    public void setIdentity(String identity) {
        this.genericWorker.setIdentity(identity);
    }

    @Override
    public long getPollBackoffInitialInterval() {
        return this.genericWorker.getPollBackoffInitialInterval();
    }

    @Override
    public void setPollBackoffInitialInterval(long backoffInitialInterval) {
        this.genericWorker.setPollBackoffInitialInterval(backoffInitialInterval);
    }

    @Override
    public long getPollBackoffMaximumInterval() {
        return this.genericWorker.getPollBackoffMaximumInterval();
    }

    @Override
    public void setPollBackoffMaximumInterval(long backoffMaximumInterval) {
        this.genericWorker.setPollBackoffMaximumInterval(backoffMaximumInterval);
    }

    @Override
    public boolean isDisableServiceShutdownOnStop() {
        return this.genericWorker.isDisableServiceShutdownOnStop();
    }

    @Override
    public void setDisableServiceShutdownOnStop(boolean disableServiceShutdownOnStop) {
        this.genericWorker.setDisableServiceShutdownOnStop(disableServiceShutdownOnStop);
    }

    @Override
    public boolean isAllowCoreThreadTimeOut() {
        return this.genericWorker.isAllowCoreThreadTimeOut();
    }

    @Override
    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.genericWorker.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    @Override
    public void setDisableTypeRegistrationOnStart(boolean disableTypeRegistrationOnStart) {
        this.genericWorker.setDisableTypeRegistrationOnStart(disableTypeRegistrationOnStart);
    }

    @Override
    public boolean isDisableTypeRegistrationOnStart() {
        return this.genericWorker.isDisableTypeRegistrationOnStart();
    }

    @Override
    public double getPollBackoffCoefficient() {
        return this.genericWorker.getPollBackoffCoefficient();
    }

    @Override
    public void setPollBackoffCoefficient(double backoffCoefficient) {
        this.genericWorker.setPollBackoffCoefficient(backoffCoefficient);
    }

    @Override
    public int getPollThreadCount() {
        return this.genericWorker.getPollThreadCount();
    }

    @Override
    public void setPollThreadCount(int threadCount) {
        this.genericWorker.setPollThreadCount(threadCount);
    }

    @Override
    public int getExecuteThreadCount() {
        return this.genericWorker.getExecuteThreadCount();
    }

    @Override
    public void setExecuteThreadCount(int threadCount) {
        this.genericWorker.setExecuteThreadCount(threadCount);
    }

    public void setChildWorkflowIdHandler(ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.genericWorker.setChildWorkflowIdHandler(childWorkflowIdHandler);
    }

    @Override
    public void suspendPolling() {
        this.genericWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.genericWorker.resumePolling();
    }

    @Override
    public boolean isPollingSuspended() {
        return this.genericWorker.isPollingSuspended();
    }

    @Override
    public void setPollingSuspended(boolean flag) {
        this.genericWorker.setPollingSuspended(flag);
    }

    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.factoryFactory.getWorkflowTypesToRegister();
    }

    @Override
    public void start() {
        this.genericWorker.start();
    }

    @Override
    public void shutdown() {
        this.genericWorker.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.genericWorker.shutdownNow();
    }

    @Override
    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.shutdownAndAwaitTermination(timeout, unit);
    }

    public void shutdownAndAwaitTermination() throws InterruptedException {
        this.shutdownAndAwaitTermination(this.terminationTimeoutSeconds, TimeUnit.SECONDS);
    }

    public void stopNow() {
        this.genericWorker.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.awaitTermination(timeout, unit);
    }

    @Override
    public boolean gracefulShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.gracefulShutdown(timeout, unit);
    }

    public void setWorkflowImplementations(Iterable<Object> workflowImplementations) throws InstantiationException, IllegalAccessException {
        for (Object workflowImplementation : workflowImplementations) {
            this.addWorkflowImplementation(workflowImplementation);
        }
    }

    public Iterable<Object> getWorkflowImplementations() {
        return this.factoryFactory.getWorkflowImplementations();
    }

    public void addWorkflowImplementation(Object workflowImplementation) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementation(workflowImplementation);
    }

    public void setMaximumAllowedComponentImplementationVersions(Map<WorkflowType, Map<String, Integer>> maximumAllowedImplementationVersions) {
        this.factoryFactory.setMaximumAllowedComponentImplementationVersions(maximumAllowedImplementationVersions);
    }

    public Map<WorkflowType, Map<String, Integer>> getMaximumAllowedComponentImplementationVersions() {
        return this.factoryFactory.getMaximumAllowedComponentImplementationVersions();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[genericWorker=" + this.genericWorker + ", factoryFactory=" + this.factoryFactory + "]";
    }

    public void stop() {
        try {
            this.gracefulShutdown(this.terminationTimeoutSeconds, TimeUnit.SECONDS);
            this.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isRunning() {
        return this.genericWorker.isRunning();
    }

    public int getPhase() {
        return this.startPhase;
    }

    public void setPhase(int startPhase) {
        this.startPhase = startPhase;
    }

    public boolean isAutoStartup() {
        return !this.disableAutoStartup;
    }

    public long getTerminationTimeoutSeconds() {
        return this.terminationTimeoutSeconds;
    }

    public void setTerminationTimeoutSeconds(long terminationTimeoutSeconds) {
        this.terminationTimeoutSeconds = terminationTimeoutSeconds;
    }

    public boolean isDisableAutoStartup() {
        return this.disableAutoStartup;
    }

    public void setDisableAutoStartup(boolean disableAutoStartup) {
        this.disableAutoStartup = disableAutoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public void registerTypesToPoll() {
        this.genericWorker.registerTypesToPoll();
    }
}

