/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.pojo;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeComponentImplementationVersion;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeImplementationOptions;
import com.amazonaws.services.simpleworkflow.flow.pojo.MethodConverterPair;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class POJOWorkflowDefinitionFactory
extends WorkflowDefinitionFactory {
    private final DataConverter converter = new JsonDataConverter();
    private final WorkflowType workflowType;
    private final WorkflowTypeRegistrationOptions registrationOptions;
    private final WorkflowTypeImplementationOptions implementationOptions;
    private final POJOWorkflowImplementationFactory implementationFactory;
    private final MethodConverterPair workflowImplementationMethod;
    private final MethodConverterPair getStateMethod;
    private final Map<String, MethodConverterPair> signals;
    private final Object[] constructorArgs;

    public POJOWorkflowDefinitionFactory(POJOWorkflowImplementationFactory implementationFactory, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, WorkflowTypeImplementationOptions implementationOptions, MethodConverterPair workflowImplementationMethod, Map<String, MethodConverterPair> signals, MethodConverterPair getStateMethod, Object[] constructorArgs) {
        this.implementationFactory = implementationFactory;
        this.workflowType = workflowType;
        this.registrationOptions = registrationOptions;
        this.workflowImplementationMethod = workflowImplementationMethod;
        this.signals = signals;
        this.getStateMethod = getStateMethod;
        this.implementationOptions = implementationOptions;
        this.constructorArgs = constructorArgs;
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public WorkflowTypeRegistrationOptions getWorkflowRegistrationOptions() {
        return this.registrationOptions;
    }

    @Override
    public WorkflowTypeImplementationOptions getWorkflowImplementationOptions() {
        return this.implementationOptions;
    }

    @Override
    public WorkflowDefinition getWorkflowDefinition(DecisionContext context) throws Exception {
        if (this.implementationFactory == null) {
            return null;
        }
        CurrentDecisionContext.set(context);
        Object workflowDefinitionObject = this.constructorArgs == null ? this.implementationFactory.newInstance(context) : this.implementationFactory.newInstance(context, this.constructorArgs);
        return new POJOWorkflowDefinition(workflowDefinitionObject, this.workflowImplementationMethod, this.signals, this.getStateMethod, this.converter, context);
    }

    @Override
    public void deleteWorkflowDefinition(WorkflowDefinition instance) {
        POJOWorkflowDefinition definition = (POJOWorkflowDefinition)instance;
        this.implementationFactory.deleteInstance(definition.getImplementationInstance());
        CurrentDecisionContext.unset();
    }

    public void setMaximumAllowedComponentImplementationVersions(Map<String, Integer> componentVersions) {
        String componentName;
        componentVersions = new HashMap<String, Integer>(componentVersions);
        List<WorkflowTypeComponentImplementationVersion> options = this.implementationOptions.getImplementationComponentVersions();
        HashMap<String, WorkflowTypeComponentImplementationVersion> implementationOptionsMap = new HashMap<String, WorkflowTypeComponentImplementationVersion>();
        for (WorkflowTypeComponentImplementationVersion workflowTypeComponentImplementationVersion : options) {
            componentName = workflowTypeComponentImplementationVersion.getComponentName();
            implementationOptionsMap.put(componentName, workflowTypeComponentImplementationVersion);
        }
        for (Map.Entry entry : componentVersions.entrySet()) {
            componentName = (String)entry.getKey();
            int maximumAllowed = (Integer)entry.getValue();
            WorkflowTypeComponentImplementationVersion implementationOption = (WorkflowTypeComponentImplementationVersion)implementationOptionsMap.get(componentName);
            if (implementationOption != null) {
                implementationOption.setMaximumAllowed(maximumAllowed);
                continue;
            }
            implementationOption = new WorkflowTypeComponentImplementationVersion(componentName, maximumAllowed, maximumAllowed, maximumAllowed);
            this.implementationOptions.getImplementationComponentVersions().add(implementationOption);
        }
    }

    public Map<String, Integer> getMaximumAllowedComponentImplementationVersions() {
        List<WorkflowTypeComponentImplementationVersion> options = this.implementationOptions.getImplementationComponentVersions();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (WorkflowTypeComponentImplementationVersion implementationVersion : options) {
            String componentName = implementationVersion.getComponentName();
            result.put(componentName, implementationVersion.getMaximumAllowed());
        }
        return result;
    }
}

