/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.config;

import java.time.Duration;

public class SimpleWorkflowClientConfig {
    private final Duration dataPlaneRequestTimeout;
    private final Duration pollingRequestTimeout;
    private final Duration controlPlaneRequestTimeout;
    private static final int DEFAULT_POLLING_REQUEST_TIMEOUT_IN_SEC = 70;
    private static final int DEFAULT_DATA_PLANE_REQUEST_TIMEOUT_IN_SEC = 6;
    private static final int DEFAULT_CONTROL_PLANE_REQUEST_TIMEOUT_IN_SEC = 10;

    public static SimpleWorkflowClientConfig ofDefaults() {
        return new SimpleWorkflowClientConfig(Duration.ofSeconds(70L), Duration.ofSeconds(6L), Duration.ofSeconds(10L));
    }

    public SimpleWorkflowClientConfig(Duration pollingRequestTimeout, Duration dataPlaneRequestTimeout, Duration controlPlaneRequestTimeout) {
        this.pollingRequestTimeout = pollingRequestTimeout;
        this.dataPlaneRequestTimeout = dataPlaneRequestTimeout;
        this.controlPlaneRequestTimeout = controlPlaneRequestTimeout;
    }

    public int getDataPlaneRequestTimeoutInMillis() {
        return (int)this.dataPlaneRequestTimeout.toMillis();
    }

    public int getPollingRequestTimeoutInMillis() {
        return (int)this.pollingRequestTimeout.toMillis();
    }

    public int getControlPlaneRequestTimeoutInMillis() {
        return (int)this.controlPlaneRequestTimeout.toMillis();
    }
}

