/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.common;

import com.amazonaws.services.simpleworkflow.model.PredefinedDuration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FlowHelpers {
    private static final Map<Class<?>, Object> defaultValues = new ConcurrentHashMap();

    public static String secondsToDuration(Long seconds) {
        if (seconds == null || seconds == -1L) {
            return PredefinedDuration.NONE.toString();
        }
        if (seconds == -2L) {
            return null;
        }
        return Long.toString(seconds);
    }

    public static long durationToSeconds(String duration) {
        if (duration == null || duration.equals(PredefinedDuration.NONE.toString())) {
            return -1L;
        }
        return Long.parseLong(duration);
    }

    public static Object[] validateInput(Method method, Object[] args) {
        Class<?>[] paramterTypes = method.getParameterTypes();
        int numberOfParameters = paramterTypes.length;
        if (args == null || args.length != numberOfParameters) {
            throw new IllegalStateException("Number of parameters does not match args size.");
        }
        int index = 0;
        for (Class<?> paramType : paramterTypes) {
            Object argument = args[index];
            if (argument != null && !paramType.isAssignableFrom(argument.getClass())) {
                throw new IllegalStateException("Param type '" + paramType.getName() + "' is not assigable from '" + argument.getClass().getName() + "'.");
            }
            ++index;
        }
        return args;
    }

    public static String taskPriorityToString(Integer taskPriority) {
        if (taskPriority == null) {
            return null;
        }
        return String.valueOf(taskPriority);
    }

    public static int taskPriorityToInt(String taskPriority) {
        if (taskPriority == null) {
            return 0;
        }
        return Integer.parseInt(taskPriority);
    }

    public static Object[] getInputParameters(Class<?>[] types, Object[] values) {
        int valuesLength = 0;
        if (values != null) {
            valuesLength = values.length;
        }
        if (valuesLength == types.length) {
            return values;
        }
        Object[] result = values == null ? new Object[types.length] : Arrays.copyOf(values, types.length);
        for (int i = valuesLength; i < types.length; ++i) {
            result[i] = FlowHelpers.getDefaultValue(types[i]);
        }
        return result;
    }

    public static Object getDefaultValue(Class<?> clazz) {
        return defaultValues.get(clazz);
    }

    static {
        defaultValues.put(Byte.TYPE, (byte)0);
        defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValues.put(Short.TYPE, (short)0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Long.TYPE, 0L);
        defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValues.put(Double.TYPE, 0.0);
        defaultValues.put(Boolean.TYPE, Boolean.FALSE);
    }
}

