/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetryWithJitter;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRetryingExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryWithJitterPolicy;
import java.util.Arrays;
import java.util.Random;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ExponentialRetryWithJitterAspect {
    private final DecisionContextProvider decisionContextProviderImpl = new DecisionContextProviderImpl();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ExponentialRetryWithJitterAspect ajc$perSingletonInstance;

    @Around(value="execution(@com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetryWithJitter * *(..)) && @annotation(exponentialRetryWithJitterAnnotation)")
    public Object retry(ProceedingJoinPoint pjp, ExponentialRetryWithJitter exponentialRetryWithJitterAnnotation) throws Throwable {
        ExponentialRetryWithJitterPolicy retryPolicy = this.createExponentialRetryWithJitterPolicy(exponentialRetryWithJitterAnnotation);
        WorkflowClock clock = this.decisionContextProviderImpl.getDecisionContext().getWorkflowClock();
        AsyncRetryingExecutor executor = new AsyncRetryingExecutor(retryPolicy, clock);
        Settable result = this.isVoidReturnType(pjp) ? null : new Settable();
        DecoratorInvocationHandler handler = new DecoratorInvocationHandler(pjp, result);
        executor.execute(handler);
        return result;
    }

    private boolean isVoidReturnType(ProceedingJoinPoint pjp) {
        boolean isVoidReturnType = false;
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            isVoidReturnType = methodSignature != null ? Void.TYPE.equals(methodSignature.getReturnType()) : false;
        }
        return isVoidReturnType;
    }

    private ExponentialRetryWithJitterPolicy createExponentialRetryWithJitterPolicy(ExponentialRetryWithJitter exponentialRetryWithJitterAnnotation) {
        String currentRunId = this.decisionContextProviderImpl.getDecisionContext().getWorkflowContext().getWorkflowExecution().getRunId();
        Random jitterCoefficientGenerator = new Random(currentRunId.hashCode());
        ExponentialRetryWithJitterPolicy retryPolicy = new ExponentialRetryWithJitterPolicy(exponentialRetryWithJitterAnnotation.initialRetryIntervalSeconds(), jitterCoefficientGenerator, exponentialRetryWithJitterAnnotation.maxJitterCoefficient());
        retryPolicy.setBackoffCoefficient(exponentialRetryWithJitterAnnotation.backoffCoefficient());
        retryPolicy.setExceptionsToExclude(Arrays.asList(exponentialRetryWithJitterAnnotation.excludeExceptions()));
        retryPolicy.setExceptionsToRetry(Arrays.asList(exponentialRetryWithJitterAnnotation.exceptionsToRetry()));
        retryPolicy.setMaximumAttempts(exponentialRetryWithJitterAnnotation.maximumAttempts());
        retryPolicy.setMaximumRetryIntervalSeconds(exponentialRetryWithJitterAnnotation.maximumRetryIntervalSeconds());
        retryPolicy.setRetryExpirationIntervalSeconds(exponentialRetryWithJitterAnnotation.retryExpirationSeconds());
        retryPolicy.validate();
        return retryPolicy;
    }

    public static ExponentialRetryWithJitterAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.amazonaws.services.simpleworkflow.flow.aspectj.ExponentialRetryWithJitterAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ExponentialRetryWithJitterAspect.ajc$perSingletonInstance = new ExponentialRetryWithJitterAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private final class DecoratorInvocationHandler
    implements AsyncRunnable {
        private final ProceedingJoinPoint pjp;
        private final Settable result;

        public DecoratorInvocationHandler(ProceedingJoinPoint pjp, Settable result) {
            this.pjp = pjp;
            this.result = result;
        }

        @Override
        public void run() throws Throwable {
            if (this.result != null) {
                this.result.unchain();
                this.result.chain((Promise)this.pjp.proceed());
            } else {
                this.pjp.proceed();
            }
        }
    }
}

