/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowWorker;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class WorkflowWorker
implements WorkerBase {
    private final GenericWorkflowWorker genericWorker;
    private final POJOWorkflowDefinitionFactoryFactory factoryFactory;
    private final Collection<Class<?>> workflowImplementationTypes = new ArrayList();

    public WorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this(new GenericWorkflowWorker(service, domain, taskListToPoll));
    }

    public WorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll, SimpleWorkflowClientConfig config) {
        this(new GenericWorkflowWorker(service, domain, taskListToPoll, config));
    }

    public WorkflowWorker(GenericWorkflowWorker genericWorker) {
        Objects.requireNonNull(genericWorker, "the workflow worker is required");
        this.genericWorker = genericWorker;
        this.factoryFactory = new POJOWorkflowDefinitionFactoryFactory();
        this.genericWorker.setWorkflowDefinitionFactoryFactory(this.factoryFactory);
    }

    @Override
    public SimpleWorkflowClientConfig getClientConfig() {
        return this.genericWorker.getClientConfig();
    }

    @Override
    public AmazonSimpleWorkflow getService() {
        return this.genericWorker.getService();
    }

    @Override
    public String getDomain() {
        return this.genericWorker.getDomain();
    }

    @Override
    public boolean isRegisterDomain() {
        return this.genericWorker.isRegisterDomain();
    }

    @Override
    public void setRegisterDomain(boolean registerDomain) {
        this.genericWorker.setRegisterDomain(registerDomain);
    }

    @Override
    public long getDomainRetentionPeriodInDays() {
        return this.genericWorker.getDomainRetentionPeriodInDays();
    }

    @Override
    public void setDomainRetentionPeriodInDays(long domainRetentionPeriodInDays) {
        this.genericWorker.setDomainRetentionPeriodInDays(domainRetentionPeriodInDays);
    }

    @Override
    public String getTaskListToPoll() {
        return this.genericWorker.getTaskListToPoll();
    }

    @Override
    public double getMaximumPollRatePerSecond() {
        return this.genericWorker.getMaximumPollRatePerSecond();
    }

    @Override
    public void setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
        this.genericWorker.setMaximumPollRatePerSecond(maximumPollRatePerSecond);
    }

    @Override
    public int getMaximumPollRateIntervalMilliseconds() {
        return this.genericWorker.getMaximumPollRateIntervalMilliseconds();
    }

    @Override
    public void setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
        this.genericWorker.setMaximumPollRateIntervalMilliseconds(maximumPollRateIntervalMilliseconds);
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.genericWorker.getUncaughtExceptionHandler();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.genericWorker.setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public String getIdentity() {
        return this.genericWorker.getIdentity();
    }

    @Override
    public void setIdentity(String identity) {
        this.genericWorker.setIdentity(identity);
    }

    @Override
    public long getPollBackoffInitialInterval() {
        return this.genericWorker.getPollBackoffInitialInterval();
    }

    @Override
    public void setPollBackoffInitialInterval(long backoffInitialInterval) {
        this.genericWorker.setPollBackoffInitialInterval(backoffInitialInterval);
    }

    @Override
    public long getPollBackoffMaximumInterval() {
        return this.genericWorker.getPollBackoffMaximumInterval();
    }

    @Override
    public void setPollBackoffMaximumInterval(long backoffMaximumInterval) {
        this.genericWorker.setPollBackoffMaximumInterval(backoffMaximumInterval);
    }

    @Override
    public boolean isDisableServiceShutdownOnStop() {
        return this.genericWorker.isDisableServiceShutdownOnStop();
    }

    @Override
    public void setDisableServiceShutdownOnStop(boolean disableServiceShutdownOnStop) {
        this.genericWorker.setDisableServiceShutdownOnStop(disableServiceShutdownOnStop);
    }

    @Override
    public boolean isAllowCoreThreadTimeOut() {
        return this.genericWorker.isAllowCoreThreadTimeOut();
    }

    @Override
    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.genericWorker.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    @Override
    public double getPollBackoffCoefficient() {
        return this.genericWorker.getPollBackoffCoefficient();
    }

    @Override
    public void setPollBackoffCoefficient(double backoffCoefficient) {
        this.genericWorker.setPollBackoffCoefficient(backoffCoefficient);
    }

    @Override
    public int getPollThreadCount() {
        return this.genericWorker.getPollThreadCount();
    }

    @Override
    public void setPollThreadCount(int threadCount) {
        this.genericWorker.setPollThreadCount(threadCount);
    }

    @Override
    public int getExecuteThreadCount() {
        return this.genericWorker.getExecuteThreadCount();
    }

    @Override
    public void setExecuteThreadCount(int threadCount) {
        this.genericWorker.setExecuteThreadCount(threadCount);
    }

    public void setChildWorkflowIdHandler(ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.genericWorker.setChildWorkflowIdHandler(childWorkflowIdHandler);
    }

    @Override
    public void registerTypesToPoll() {
        this.genericWorker.registerTypesToPoll();
    }

    @Override
    public void start() {
        this.genericWorker.start();
    }

    @Override
    public void shutdown() {
        this.genericWorker.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.genericWorker.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.awaitTermination(timeout, unit);
    }

    @Override
    public boolean gracefulShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.gracefulShutdown(timeout, unit);
    }

    @Override
    public boolean isRunning() {
        return this.genericWorker.isRunning();
    }

    @Override
    public void suspendPolling() {
        this.genericWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.genericWorker.resumePolling();
    }

    @Override
    public boolean isPollingSuspended() {
        return this.genericWorker.isPollingSuspended();
    }

    @Override
    public void setPollingSuspended(boolean flag) {
        this.genericWorker.setPollingSuspended(flag);
    }

    public void setWorkflowImplementationTypes(Collection<Class<?>> workflowImplementationTypes) throws InstantiationException, IllegalAccessException {
        for (Class<?> workflowImplementationType : workflowImplementationTypes) {
            this.addWorkflowImplementationType(workflowImplementationType);
        }
    }

    public Collection<Class<?>> getWorkflowImplementationTypes() {
        return this.workflowImplementationTypes;
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType);
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, DataConverter converter) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType, converter);
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, DataConverter converter, Object[] constructorArgs) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType, converter, constructorArgs, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[genericWorker=" + this.genericWorker + ", wokflowImplementationTypes=" + this.workflowImplementationTypes + "]";
    }

    @Override
    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.shutdownAndAwaitTermination(timeout, unit);
    }

    public DataConverter getDataConverter() {
        return this.factoryFactory.getDataConverter();
    }

    public void setDefaultConverter(DataConverter converter) {
        this.factoryFactory.setDataConverter(converter);
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, Map<String, Integer> maximumAllowedComponentImplementationVersions) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType, maximumAllowedComponentImplementationVersions);
    }

    @Override
    public void setDisableTypeRegistrationOnStart(boolean disableTypeRegistrationOnStart) {
        this.genericWorker.setDisableTypeRegistrationOnStart(disableTypeRegistrationOnStart);
    }

    @Override
    public boolean isDisableTypeRegistrationOnStart() {
        return this.genericWorker.isDisableTypeRegistrationOnStart();
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, DataConverter converter, Map<String, Integer> maximumAllowedComponentImplementationVersions) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType, converter, null, maximumAllowedComponentImplementationVersions);
    }

    public void setMaximumAllowedComponentImplementationVersions(Map<WorkflowType, Map<String, Integer>> maximumAllowedImplementationVersions) {
        this.factoryFactory.setMaximumAllowedComponentImplementationVersions(maximumAllowedImplementationVersions);
    }

    public Map<WorkflowType, Map<String, Integer>> getMaximumAllowedComponentImplementationVersions() {
        return this.factoryFactory.getMaximumAllowedComponentImplementationVersions();
    }
}

