/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.ManualActivityCompletionClient;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import java.util.concurrent.CancellationException;

class ManualActivityCompletionClientImpl
extends ManualActivityCompletionClient {
    private final AmazonSimpleWorkflow service;
    private final String taskToken;
    private final DataConverter dataConverter;
    private SimpleWorkflowClientConfig config;

    public ManualActivityCompletionClientImpl(AmazonSimpleWorkflow service, String taskToken, DataConverter dataConverter) {
        this(service, taskToken, dataConverter, null);
    }

    public ManualActivityCompletionClientImpl(AmazonSimpleWorkflow service, String taskToken, DataConverter dataConverter, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.taskToken = taskToken;
        this.dataConverter = dataConverter;
        this.config = config;
    }

    @Override
    public void complete(Object result) {
        RespondActivityTaskCompletedRequest request = new RespondActivityTaskCompletedRequest();
        String convertedResult = this.dataConverter.toData(result);
        request.setResult(convertedResult);
        request.setTaskToken(this.taskToken);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.respondActivityTaskCompleted(request);
    }

    @Override
    public void fail(Throwable failure) {
        RespondActivityTaskFailedRequest request = new RespondActivityTaskFailedRequest();
        String convertedFailure = this.dataConverter.toData(failure);
        request.setReason(WorkflowExecutionUtils.truncateReason(failure.getMessage()));
        request.setDetails(convertedFailure);
        request.setTaskToken(this.taskToken);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.respondActivityTaskFailed(request);
    }

    @Override
    public void recordHeartbeat(String details) throws CancellationException {
        RecordActivityTaskHeartbeatRequest request = new RecordActivityTaskHeartbeatRequest();
        request.setDetails(details);
        request.setTaskToken(this.taskToken);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        ActivityTaskStatus status = this.service.recordActivityTaskHeartbeat(request);
        if (status.isCancelRequested().booleanValue()) {
            throw new CancellationException();
        }
    }

    @Override
    public void reportCancellation(String details) {
        RespondActivityTaskCanceledRequest request = new RespondActivityTaskCanceledRequest();
        request.setDetails(details);
        request.setTaskToken(this.taskToken);
        RequestTimeoutHelper.overrideDataPlaneRequestTimeout((AmazonWebServiceRequest)request, this.config);
        this.service.respondActivityTaskCanceled(request);
    }
}

