/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.VolumeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVolumesResult
implements Serializable,
Cloneable {
    private String gatewayARN;
    private String marker;
    private ListWithAutoConstructFlag<VolumeInfo> volumeInfos;

    public String getGatewayARN() {
        return this.gatewayARN;
    }

    public void setGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
    }

    public ListVolumesResult withGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListVolumesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<VolumeInfo> getVolumeInfos() {
        if (this.volumeInfos == null) {
            this.volumeInfos = new ListWithAutoConstructFlag();
            this.volumeInfos.setAutoConstruct(true);
        }
        return this.volumeInfos;
    }

    public void setVolumeInfos(Collection<VolumeInfo> volumeInfos) {
        if (volumeInfos == null) {
            this.volumeInfos = null;
            return;
        }
        ListWithAutoConstructFlag volumeInfosCopy = new ListWithAutoConstructFlag(volumeInfos.size());
        volumeInfosCopy.addAll(volumeInfos);
        this.volumeInfos = volumeInfosCopy;
    }

    public ListVolumesResult withVolumeInfos(VolumeInfo ... volumeInfos) {
        if (this.getVolumeInfos() == null) {
            this.setVolumeInfos(new ArrayList<VolumeInfo>(volumeInfos.length));
        }
        for (VolumeInfo value : volumeInfos) {
            this.getVolumeInfos().add(value);
        }
        return this;
    }

    public ListVolumesResult withVolumeInfos(Collection<VolumeInfo> volumeInfos) {
        if (volumeInfos == null) {
            this.volumeInfos = null;
        } else {
            ListWithAutoConstructFlag volumeInfosCopy = new ListWithAutoConstructFlag(volumeInfos.size());
            volumeInfosCopy.addAll(volumeInfos);
            this.volumeInfos = volumeInfosCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGatewayARN() != null) {
            sb.append("GatewayARN: " + this.getGatewayARN() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getVolumeInfos() != null) {
            sb.append("VolumeInfos: " + this.getVolumeInfos());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGatewayARN() == null ? 0 : this.getGatewayARN().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeInfos() == null ? 0 : this.getVolumeInfos().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumesResult)) {
            return false;
        }
        ListVolumesResult other = (ListVolumesResult)obj;
        if (other.getGatewayARN() == null ^ this.getGatewayARN() == null) {
            return false;
        }
        if (other.getGatewayARN() != null && !other.getGatewayARN().equals(this.getGatewayARN())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getVolumeInfos() == null ^ this.getVolumeInfos() == null) {
            return false;
        }
        return other.getVolumeInfos() == null || other.getVolumeInfos().equals(this.getVolumeInfos());
    }

    public ListVolumesResult clone() {
        try {
            return (ListVolumesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

