/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateTapeWithBarcodeRequestMarshaller
implements Marshaller<Request<CreateTapeWithBarcodeRequest>, CreateTapeWithBarcodeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateTapeWithBarcodeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateTapeWithBarcodeRequest> marshall(CreateTapeWithBarcodeRequest createTapeWithBarcodeRequest) {
        if (createTapeWithBarcodeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTapeWithBarcodeRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.CreateTapeWithBarcode");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createTapeWithBarcodeRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(createTapeWithBarcodeRequest.getGatewayARN());
            }
            if (createTapeWithBarcodeRequest.getTapeSizeInBytes() != null) {
                jsonGenerator.writeFieldName("TapeSizeInBytes").writeValue(createTapeWithBarcodeRequest.getTapeSizeInBytes().longValue());
            }
            if (createTapeWithBarcodeRequest.getTapeBarcode() != null) {
                jsonGenerator.writeFieldName("TapeBarcode").writeValue(createTapeWithBarcodeRequest.getTapeBarcode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

