/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.storagegateway.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes an iSCSI cached volume.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CachediSCSIVolume" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CachediSCSIVolume implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     */
    private String volumeARN;
    /**
     * <p>
     * The unique identifier of the volume, e.g. vol-AE4B946D.
     * </p>
     */
    private String volumeId;
    /**
     * <p>
     * One of the VolumeType enumeration values that describes the type of the volume.
     * </p>
     */
    private String volumeType;
    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     */
    private String volumeStatus;
    /**
     * <p>
     * The size, in bytes, of the volume capacity.
     * </p>
     */
    private Long volumeSizeInBytes;
    /**
     * <p>
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
     * data transferred. This field does not appear in the response if the cached volume is not restoring or
     * bootstrapping.
     * </p>
     */
    private Double volumeProgress;
    /**
     * <p>
     * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663.
     * Otherwise, this field is not included.
     * </p>
     */
    private String sourceSnapshotId;
    /**
     * <p>
     * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.
     * </p>
     */
    private VolumeiSCSIAttributes volumeiSCSIAttributes;
    /**
     * <p>
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     * </p>
     */
    private java.util.Date createdDate;
    /**
     * <p>
     * The size of the data stored on the volume in bytes.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     */
    private Long volumeUsedInBytes;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     * 
     * @param volumeARN
     *        The Amazon Resource Name (ARN) of the storage volume.
     */

    public void setVolumeARN(String volumeARN) {
        this.volumeARN = volumeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage volume.
     */

    public String getVolumeARN() {
        return this.volumeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     * 
     * @param volumeARN
     *        The Amazon Resource Name (ARN) of the storage volume.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeARN(String volumeARN) {
        setVolumeARN(volumeARN);
        return this;
    }

    /**
     * <p>
     * The unique identifier of the volume, e.g. vol-AE4B946D.
     * </p>
     * 
     * @param volumeId
     *        The unique identifier of the volume, e.g. vol-AE4B946D.
     */

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    /**
     * <p>
     * The unique identifier of the volume, e.g. vol-AE4B946D.
     * </p>
     * 
     * @return The unique identifier of the volume, e.g. vol-AE4B946D.
     */

    public String getVolumeId() {
        return this.volumeId;
    }

    /**
     * <p>
     * The unique identifier of the volume, e.g. vol-AE4B946D.
     * </p>
     * 
     * @param volumeId
     *        The unique identifier of the volume, e.g. vol-AE4B946D.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeId(String volumeId) {
        setVolumeId(volumeId);
        return this;
    }

    /**
     * <p>
     * One of the VolumeType enumeration values that describes the type of the volume.
     * </p>
     * 
     * @param volumeType
     *        One of the VolumeType enumeration values that describes the type of the volume.
     */

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    /**
     * <p>
     * One of the VolumeType enumeration values that describes the type of the volume.
     * </p>
     * 
     * @return One of the VolumeType enumeration values that describes the type of the volume.
     */

    public String getVolumeType() {
        return this.volumeType;
    }

    /**
     * <p>
     * One of the VolumeType enumeration values that describes the type of the volume.
     * </p>
     * 
     * @param volumeType
     *        One of the VolumeType enumeration values that describes the type of the volume.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeType(String volumeType) {
        setVolumeType(volumeType);
        return this;
    }

    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     * 
     * @param volumeStatus
     *        One of the VolumeStatus values that indicates the state of the storage volume.
     */

    public void setVolumeStatus(String volumeStatus) {
        this.volumeStatus = volumeStatus;
    }

    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     * 
     * @return One of the VolumeStatus values that indicates the state of the storage volume.
     */

    public String getVolumeStatus() {
        return this.volumeStatus;
    }

    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     * 
     * @param volumeStatus
     *        One of the VolumeStatus values that indicates the state of the storage volume.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeStatus(String volumeStatus) {
        setVolumeStatus(volumeStatus);
        return this;
    }

    /**
     * <p>
     * The size, in bytes, of the volume capacity.
     * </p>
     * 
     * @param volumeSizeInBytes
     *        The size, in bytes, of the volume capacity.
     */

    public void setVolumeSizeInBytes(Long volumeSizeInBytes) {
        this.volumeSizeInBytes = volumeSizeInBytes;
    }

    /**
     * <p>
     * The size, in bytes, of the volume capacity.
     * </p>
     * 
     * @return The size, in bytes, of the volume capacity.
     */

    public Long getVolumeSizeInBytes() {
        return this.volumeSizeInBytes;
    }

    /**
     * <p>
     * The size, in bytes, of the volume capacity.
     * </p>
     * 
     * @param volumeSizeInBytes
     *        The size, in bytes, of the volume capacity.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeSizeInBytes(Long volumeSizeInBytes) {
        setVolumeSizeInBytes(volumeSizeInBytes);
        return this;
    }

    /**
     * <p>
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
     * data transferred. This field does not appear in the response if the cached volume is not restoring or
     * bootstrapping.
     * </p>
     * 
     * @param volumeProgress
     *        Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent
     *        of data transferred. This field does not appear in the response if the cached volume is not restoring or
     *        bootstrapping.
     */

    public void setVolumeProgress(Double volumeProgress) {
        this.volumeProgress = volumeProgress;
    }

    /**
     * <p>
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
     * data transferred. This field does not appear in the response if the cached volume is not restoring or
     * bootstrapping.
     * </p>
     * 
     * @return Represents the percentage complete if the volume is restoring or bootstrapping that represents the
     *         percent of data transferred. This field does not appear in the response if the cached volume is not
     *         restoring or bootstrapping.
     */

    public Double getVolumeProgress() {
        return this.volumeProgress;
    }

    /**
     * <p>
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
     * data transferred. This field does not appear in the response if the cached volume is not restoring or
     * bootstrapping.
     * </p>
     * 
     * @param volumeProgress
     *        Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent
     *        of data transferred. This field does not appear in the response if the cached volume is not restoring or
     *        bootstrapping.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeProgress(Double volumeProgress) {
        setVolumeProgress(volumeProgress);
        return this;
    }

    /**
     * <p>
     * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663.
     * Otherwise, this field is not included.
     * </p>
     * 
     * @param sourceSnapshotId
     *        If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g.
     *        snap-78e22663. Otherwise, this field is not included.
     */

    public void setSourceSnapshotId(String sourceSnapshotId) {
        this.sourceSnapshotId = sourceSnapshotId;
    }

    /**
     * <p>
     * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663.
     * Otherwise, this field is not included.
     * </p>
     * 
     * @return If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g.
     *         snap-78e22663. Otherwise, this field is not included.
     */

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    /**
     * <p>
     * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663.
     * Otherwise, this field is not included.
     * </p>
     * 
     * @param sourceSnapshotId
     *        If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g.
     *        snap-78e22663. Otherwise, this field is not included.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withSourceSnapshotId(String sourceSnapshotId) {
        setSourceSnapshotId(sourceSnapshotId);
        return this;
    }

    /**
     * <p>
     * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.
     * </p>
     * 
     * @param volumeiSCSIAttributes
     *        An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
     *        volume.
     */

    public void setVolumeiSCSIAttributes(VolumeiSCSIAttributes volumeiSCSIAttributes) {
        this.volumeiSCSIAttributes = volumeiSCSIAttributes;
    }

    /**
     * <p>
     * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.
     * </p>
     * 
     * @return An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
     *         volume.
     */

    public VolumeiSCSIAttributes getVolumeiSCSIAttributes() {
        return this.volumeiSCSIAttributes;
    }

    /**
     * <p>
     * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.
     * </p>
     * 
     * @param volumeiSCSIAttributes
     *        An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
     *        volume.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeiSCSIAttributes(VolumeiSCSIAttributes volumeiSCSIAttributes) {
        setVolumeiSCSIAttributes(volumeiSCSIAttributes);
        return this;
    }

    /**
     * <p>
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     * </p>
     * 
     * @param createdDate
     *        The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     */

    public void setCreatedDate(java.util.Date createdDate) {
        this.createdDate = createdDate;
    }

    /**
     * <p>
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     * </p>
     * 
     * @return The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     */

    public java.util.Date getCreatedDate() {
        return this.createdDate;
    }

    /**
     * <p>
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     * </p>
     * 
     * @param createdDate
     *        The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withCreatedDate(java.util.Date createdDate) {
        setCreatedDate(createdDate);
        return this;
    }

    /**
     * <p>
     * The size of the data stored on the volume in bytes.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     * 
     * @param volumeUsedInBytes
     *        The size of the data stored on the volume in bytes.</p> <note>
     *        <p>
     *        This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     *        </p>
     */

    public void setVolumeUsedInBytes(Long volumeUsedInBytes) {
        this.volumeUsedInBytes = volumeUsedInBytes;
    }

    /**
     * <p>
     * The size of the data stored on the volume in bytes.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     * 
     * @return The size of the data stored on the volume in bytes.</p> <note>
     *         <p>
     *         This value is not available for volumes created prior to May 13, 2015, until you store data on the
     *         volume.
     *         </p>
     */

    public Long getVolumeUsedInBytes() {
        return this.volumeUsedInBytes;
    }

    /**
     * <p>
     * The size of the data stored on the volume in bytes.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     * 
     * @param volumeUsedInBytes
     *        The size of the data stored on the volume in bytes.</p> <note>
     *        <p>
     *        This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CachediSCSIVolume withVolumeUsedInBytes(Long volumeUsedInBytes) {
        setVolumeUsedInBytes(volumeUsedInBytes);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVolumeARN() != null)
            sb.append("VolumeARN: ").append(getVolumeARN()).append(",");
        if (getVolumeId() != null)
            sb.append("VolumeId: ").append(getVolumeId()).append(",");
        if (getVolumeType() != null)
            sb.append("VolumeType: ").append(getVolumeType()).append(",");
        if (getVolumeStatus() != null)
            sb.append("VolumeStatus: ").append(getVolumeStatus()).append(",");
        if (getVolumeSizeInBytes() != null)
            sb.append("VolumeSizeInBytes: ").append(getVolumeSizeInBytes()).append(",");
        if (getVolumeProgress() != null)
            sb.append("VolumeProgress: ").append(getVolumeProgress()).append(",");
        if (getSourceSnapshotId() != null)
            sb.append("SourceSnapshotId: ").append(getSourceSnapshotId()).append(",");
        if (getVolumeiSCSIAttributes() != null)
            sb.append("VolumeiSCSIAttributes: ").append(getVolumeiSCSIAttributes()).append(",");
        if (getCreatedDate() != null)
            sb.append("CreatedDate: ").append(getCreatedDate()).append(",");
        if (getVolumeUsedInBytes() != null)
            sb.append("VolumeUsedInBytes: ").append(getVolumeUsedInBytes());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CachediSCSIVolume == false)
            return false;
        CachediSCSIVolume other = (CachediSCSIVolume) obj;
        if (other.getVolumeARN() == null ^ this.getVolumeARN() == null)
            return false;
        if (other.getVolumeARN() != null && other.getVolumeARN().equals(this.getVolumeARN()) == false)
            return false;
        if (other.getVolumeId() == null ^ this.getVolumeId() == null)
            return false;
        if (other.getVolumeId() != null && other.getVolumeId().equals(this.getVolumeId()) == false)
            return false;
        if (other.getVolumeType() == null ^ this.getVolumeType() == null)
            return false;
        if (other.getVolumeType() != null && other.getVolumeType().equals(this.getVolumeType()) == false)
            return false;
        if (other.getVolumeStatus() == null ^ this.getVolumeStatus() == null)
            return false;
        if (other.getVolumeStatus() != null && other.getVolumeStatus().equals(this.getVolumeStatus()) == false)
            return false;
        if (other.getVolumeSizeInBytes() == null ^ this.getVolumeSizeInBytes() == null)
            return false;
        if (other.getVolumeSizeInBytes() != null && other.getVolumeSizeInBytes().equals(this.getVolumeSizeInBytes()) == false)
            return false;
        if (other.getVolumeProgress() == null ^ this.getVolumeProgress() == null)
            return false;
        if (other.getVolumeProgress() != null && other.getVolumeProgress().equals(this.getVolumeProgress()) == false)
            return false;
        if (other.getSourceSnapshotId() == null ^ this.getSourceSnapshotId() == null)
            return false;
        if (other.getSourceSnapshotId() != null && other.getSourceSnapshotId().equals(this.getSourceSnapshotId()) == false)
            return false;
        if (other.getVolumeiSCSIAttributes() == null ^ this.getVolumeiSCSIAttributes() == null)
            return false;
        if (other.getVolumeiSCSIAttributes() != null && other.getVolumeiSCSIAttributes().equals(this.getVolumeiSCSIAttributes()) == false)
            return false;
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null)
            return false;
        if (other.getCreatedDate() != null && other.getCreatedDate().equals(this.getCreatedDate()) == false)
            return false;
        if (other.getVolumeUsedInBytes() == null ^ this.getVolumeUsedInBytes() == null)
            return false;
        if (other.getVolumeUsedInBytes() != null && other.getVolumeUsedInBytes().equals(this.getVolumeUsedInBytes()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVolumeARN() == null) ? 0 : getVolumeARN().hashCode());
        hashCode = prime * hashCode + ((getVolumeId() == null) ? 0 : getVolumeId().hashCode());
        hashCode = prime * hashCode + ((getVolumeType() == null) ? 0 : getVolumeType().hashCode());
        hashCode = prime * hashCode + ((getVolumeStatus() == null) ? 0 : getVolumeStatus().hashCode());
        hashCode = prime * hashCode + ((getVolumeSizeInBytes() == null) ? 0 : getVolumeSizeInBytes().hashCode());
        hashCode = prime * hashCode + ((getVolumeProgress() == null) ? 0 : getVolumeProgress().hashCode());
        hashCode = prime * hashCode + ((getSourceSnapshotId() == null) ? 0 : getSourceSnapshotId().hashCode());
        hashCode = prime * hashCode + ((getVolumeiSCSIAttributes() == null) ? 0 : getVolumeiSCSIAttributes().hashCode());
        hashCode = prime * hashCode + ((getCreatedDate() == null) ? 0 : getCreatedDate().hashCode());
        hashCode = prime * hashCode + ((getVolumeUsedInBytes() == null) ? 0 : getVolumeUsedInBytes().hashCode());
        return hashCode;
    }

    @Override
    public CachediSCSIVolume clone() {
        try {
            return (CachediSCSIVolume) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.storagegateway.model.transform.CachediSCSIVolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
