/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.states.InputOutputPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

public final class SucceedState
implements State {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonUnwrapped
    private final PathContainer pathContainer;

    private SucceedState(Builder builder) {
        this.comment = builder.comment;
        this.pathContainer = builder.pathContainer.build();
    }

    @Override
    public String getType() {
        return "Succeed";
    }

    public String getComment() {
        return this.comment;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.pathContainer.getInputPath();
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.pathContainer.getOutputPath();
    }

    @Override
    public boolean isTerminalState() {
        return true;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements State.Builder,
    InputOutputPathBuilder<Builder> {
        @JsonProperty(value="Comment")
        private String comment;
        private final PathContainer.Builder pathContainer = PathContainer.builder();

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder inputPath(String inputPath) {
            this.pathContainer.inputPath(inputPath);
            return this;
        }

        @Override
        public Builder outputPath(String outputPath) {
            this.pathContainer.outputPath(outputPath);
            return this;
        }

        @Override
        public SucceedState build() {
            return new SucceedState(this);
        }
    }
}

