/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.Choice;
import com.amazonaws.services.stepfunctions.builder.states.InputOutputPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ChoiceState
implements State {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="Default")
    private final String defaultStateName;
    @JsonProperty(value="Choices")
    private final List<Choice> choices;
    @JsonUnwrapped
    private final PathContainer pathContainer;

    private ChoiceState(Builder builder) {
        this.comment = builder.comment;
        this.defaultStateName = builder.defaultStateName;
        this.choices = Buildable.Utils.build(builder.choices);
        this.pathContainer = builder.pathContainer.build();
    }

    @Override
    public String getType() {
        return "Choice";
    }

    public String getComment() {
        return this.comment;
    }

    public String getDefaultStateName() {
        return this.defaultStateName;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.pathContainer.getInputPath();
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.pathContainer.getOutputPath();
    }

    @Override
    public boolean isTerminalState() {
        return false;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements State.Builder,
    InputOutputPathBuilder<Builder> {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="Default")
        private String defaultStateName;
        @JsonProperty(value="Choices")
        private List<Choice.Builder> choices = new ArrayList<Choice.Builder>();
        private final PathContainer.Builder pathContainer = PathContainer.builder();

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder defaultStateName(String defaultStateName) {
            this.defaultStateName = defaultStateName;
            return this;
        }

        public Builder choice(Choice.Builder choiceBuilder) {
            this.choices.add(choiceBuilder);
            return this;
        }

        public Builder choices(Choice.Builder ... choiceBuilders) {
            Collections.addAll(this.choices, choiceBuilders);
            return this;
        }

        @Override
        public Builder inputPath(String inputPath) {
            this.pathContainer.inputPath(inputPath);
            return this;
        }

        @Override
        public Builder outputPath(String outputPath) {
            this.pathContainer.outputPath(outputPath);
            return this;
        }

        @Override
        public ChoiceState build() {
            return new ChoiceState(this);
        }
    }
}

