/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssoadmin.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure that describes a trusted token issuer and associates it with a set of authorized audiences.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AuthorizedTokenIssuer" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AuthorizedTokenIssuer implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     */
    private java.util.List<String> authorizedAudiences;
    /**
     * <p>
     * The ARN of the trusted token issuer.
     * </p>
     */
    private String trustedTokenIssuerArn;

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     * 
     * @return An array list of authorized audiences, or applications, that can consume the tokens generated by the
     *         associated trusted token issuer.
     */

    public java.util.List<String> getAuthorizedAudiences() {
        return authorizedAudiences;
    }

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     * 
     * @param authorizedAudiences
     *        An array list of authorized audiences, or applications, that can consume the tokens generated by the
     *        associated trusted token issuer.
     */

    public void setAuthorizedAudiences(java.util.Collection<String> authorizedAudiences) {
        if (authorizedAudiences == null) {
            this.authorizedAudiences = null;
            return;
        }

        this.authorizedAudiences = new java.util.ArrayList<String>(authorizedAudiences);
    }

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAuthorizedAudiences(java.util.Collection)} or {@link #withAuthorizedAudiences(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param authorizedAudiences
     *        An array list of authorized audiences, or applications, that can consume the tokens generated by the
     *        associated trusted token issuer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AuthorizedTokenIssuer withAuthorizedAudiences(String... authorizedAudiences) {
        if (this.authorizedAudiences == null) {
            setAuthorizedAudiences(new java.util.ArrayList<String>(authorizedAudiences.length));
        }
        for (String ele : authorizedAudiences) {
            this.authorizedAudiences.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     * 
     * @param authorizedAudiences
     *        An array list of authorized audiences, or applications, that can consume the tokens generated by the
     *        associated trusted token issuer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AuthorizedTokenIssuer withAuthorizedAudiences(java.util.Collection<String> authorizedAudiences) {
        setAuthorizedAudiences(authorizedAudiences);
        return this;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer.
     * </p>
     * 
     * @param trustedTokenIssuerArn
     *        The ARN of the trusted token issuer.
     */

    public void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
        this.trustedTokenIssuerArn = trustedTokenIssuerArn;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer.
     * </p>
     * 
     * @return The ARN of the trusted token issuer.
     */

    public String getTrustedTokenIssuerArn() {
        return this.trustedTokenIssuerArn;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer.
     * </p>
     * 
     * @param trustedTokenIssuerArn
     *        The ARN of the trusted token issuer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AuthorizedTokenIssuer withTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
        setTrustedTokenIssuerArn(trustedTokenIssuerArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAuthorizedAudiences() != null)
            sb.append("AuthorizedAudiences: ").append(getAuthorizedAudiences()).append(",");
        if (getTrustedTokenIssuerArn() != null)
            sb.append("TrustedTokenIssuerArn: ").append(getTrustedTokenIssuerArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AuthorizedTokenIssuer == false)
            return false;
        AuthorizedTokenIssuer other = (AuthorizedTokenIssuer) obj;
        if (other.getAuthorizedAudiences() == null ^ this.getAuthorizedAudiences() == null)
            return false;
        if (other.getAuthorizedAudiences() != null && other.getAuthorizedAudiences().equals(this.getAuthorizedAudiences()) == false)
            return false;
        if (other.getTrustedTokenIssuerArn() == null ^ this.getTrustedTokenIssuerArn() == null)
            return false;
        if (other.getTrustedTokenIssuerArn() != null && other.getTrustedTokenIssuerArn().equals(this.getTrustedTokenIssuerArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAuthorizedAudiences() == null) ? 0 : getAuthorizedAudiences().hashCode());
        hashCode = prime * hashCode + ((getTrustedTokenIssuerArn() == null) ? 0 : getTrustedTokenIssuerArn().hashCode());
        return hashCode;
    }

    @Override
    public AuthorizedTokenIssuer clone() {
        try {
            return (AuthorizedTokenIssuer) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ssoadmin.model.transform.AuthorizedTokenIssuerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
