/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.ApplicationDiscoveryStatus;
import com.amazonaws.services.ssmsap.model.ApplicationType;
import com.amazonaws.services.ssmsap.model.transform.ApplicationSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ApplicationSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String discoveryStatus;
    private String type;
    private String arn;
    private Map<String, String> tags;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ApplicationSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDiscoveryStatus(String discoveryStatus) {
        this.discoveryStatus = discoveryStatus;
    }

    public String getDiscoveryStatus() {
        return this.discoveryStatus;
    }

    public ApplicationSummary withDiscoveryStatus(String discoveryStatus) {
        this.setDiscoveryStatus(discoveryStatus);
        return this;
    }

    public ApplicationSummary withDiscoveryStatus(ApplicationDiscoveryStatus discoveryStatus) {
        this.discoveryStatus = discoveryStatus.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ApplicationSummary withType(String type) {
        this.setType(type);
        return this;
    }

    public ApplicationSummary withType(ApplicationType type) {
        this.type = type.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ApplicationSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ApplicationSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ApplicationSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ApplicationSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDiscoveryStatus() != null) {
            sb.append("DiscoveryStatus: ").append(this.getDiscoveryStatus()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDiscoveryStatus() == null ^ this.getDiscoveryStatus() == null) {
            return false;
        }
        if (other.getDiscoveryStatus() != null && !other.getDiscoveryStatus().equals(this.getDiscoveryStatus())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDiscoveryStatus() == null ? 0 : this.getDiscoveryStatus().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ApplicationSummary clone() {
        try {
            return (ApplicationSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

