/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.CredentialType;
import com.amazonaws.services.ssmsap.model.transform.ApplicationCredentialMarshaller;
import java.io.Serializable;

public class ApplicationCredential
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseName;
    private String credentialType;
    private String secretId;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ApplicationCredential withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public ApplicationCredential withCredentialType(String credentialType) {
        this.setCredentialType(credentialType);
        return this;
    }

    public ApplicationCredential withCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType.toString();
        return this;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public ApplicationCredential withSecretId(String secretId) {
        this.setSecretId(secretId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getCredentialType() != null) {
            sb.append("CredentialType: ").append(this.getCredentialType()).append(",");
        }
        if (this.getSecretId() != null) {
            sb.append("SecretId: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCredential)) {
            return false;
        }
        ApplicationCredential other = (ApplicationCredential)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getCredentialType() == null ^ this.getCredentialType() == null) {
            return false;
        }
        if (other.getCredentialType() != null && !other.getCredentialType().equals(this.getCredentialType())) {
            return false;
        }
        if (other.getSecretId() == null ^ this.getSecretId() == null) {
            return false;
        }
        return other.getSecretId() == null || other.getSecretId().equals(this.getSecretId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getCredentialType() == null ? 0 : this.getCredentialType().hashCode());
        hashCode = 31 * hashCode + (this.getSecretId() == null ? 0 : this.getSecretId().hashCode());
        return hashCode;
    }

    public ApplicationCredential clone() {
        try {
            return (ApplicationCredential)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationCredentialMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

