/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.RecurrenceSettings;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class RecurrenceSettingsMarshaller {
    private static final MarshallingInfo<List> MONTHLYSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonthlySettings").build();
    private static final MarshallingInfo<List> WEEKLYSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WeeklySettings").build();
    private static final MarshallingInfo<List> DAILYSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DailySettings").build();
    private static final MarshallingInfo<Integer> NUMBEROFONCALLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfOnCalls").build();
    private static final MarshallingInfo<Map> SHIFTCOVERAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShiftCoverages").build();
    private static final MarshallingInfo<Integer> RECURRENCEMULTIPLIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurrenceMultiplier").build();
    private static final RecurrenceSettingsMarshaller instance = new RecurrenceSettingsMarshaller();

    public static RecurrenceSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecurrenceSettings recurrenceSettings, ProtocolMarshaller protocolMarshaller) {
        if (recurrenceSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recurrenceSettings.getMonthlySettings(), MONTHLYSETTINGS_BINDING);
            protocolMarshaller.marshall(recurrenceSettings.getWeeklySettings(), WEEKLYSETTINGS_BINDING);
            protocolMarshaller.marshall(recurrenceSettings.getDailySettings(), DAILYSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)recurrenceSettings.getNumberOfOnCalls(), NUMBEROFONCALLS_BINDING);
            protocolMarshaller.marshall(recurrenceSettings.getShiftCoverages(), SHIFTCOVERAGES_BINDING);
            protocolMarshaller.marshall((Object)recurrenceSettings.getRecurrenceMultiplier(), RECURRENCEMULTIPLIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

