/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.Runbook;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartChangeRequestExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date scheduledTime;
    private String documentName;
    private String documentVersion;
    private Map<String, List<String>> parameters;
    private String changeRequestName;
    private String clientToken;
    private SdkInternalList<Runbook> runbooks;
    private SdkInternalList<Tag> tags;
    private Date scheduledEndTime;
    private String changeDetails;

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public StartChangeRequestExecutionRequest withScheduledTime(Date scheduledTime) {
        this.setScheduledTime(scheduledTime);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public StartChangeRequestExecutionRequest withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public StartChangeRequestExecutionRequest withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public StartChangeRequestExecutionRequest withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public StartChangeRequestExecutionRequest addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public StartChangeRequestExecutionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setChangeRequestName(String changeRequestName) {
        this.changeRequestName = changeRequestName;
    }

    public String getChangeRequestName() {
        return this.changeRequestName;
    }

    public StartChangeRequestExecutionRequest withChangeRequestName(String changeRequestName) {
        this.setChangeRequestName(changeRequestName);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartChangeRequestExecutionRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Runbook> getRunbooks() {
        if (this.runbooks == null) {
            this.runbooks = new SdkInternalList();
        }
        return this.runbooks;
    }

    public void setRunbooks(Collection<Runbook> runbooks) {
        if (runbooks == null) {
            this.runbooks = null;
            return;
        }
        this.runbooks = new SdkInternalList(runbooks);
    }

    public StartChangeRequestExecutionRequest withRunbooks(Runbook ... runbooks) {
        if (this.runbooks == null) {
            this.setRunbooks((Collection<Runbook>)new SdkInternalList(runbooks.length));
        }
        for (Runbook ele : runbooks) {
            this.runbooks.add((Object)ele);
        }
        return this;
    }

    public StartChangeRequestExecutionRequest withRunbooks(Collection<Runbook> runbooks) {
        this.setRunbooks(runbooks);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public StartChangeRequestExecutionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public StartChangeRequestExecutionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public StartChangeRequestExecutionRequest withScheduledEndTime(Date scheduledEndTime) {
        this.setScheduledEndTime(scheduledEndTime);
        return this;
    }

    public void setChangeDetails(String changeDetails) {
        this.changeDetails = changeDetails;
    }

    public String getChangeDetails() {
        return this.changeDetails;
    }

    public StartChangeRequestExecutionRequest withChangeDetails(String changeDetails) {
        this.setChangeDetails(changeDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScheduledTime() != null) {
            sb.append("ScheduledTime: ").append(this.getScheduledTime()).append(",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getChangeRequestName() != null) {
            sb.append("ChangeRequestName: ").append(this.getChangeRequestName()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getRunbooks() != null) {
            sb.append("Runbooks: ").append(this.getRunbooks()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getScheduledEndTime() != null) {
            sb.append("ScheduledEndTime: ").append(this.getScheduledEndTime()).append(",");
        }
        if (this.getChangeDetails() != null) {
            sb.append("ChangeDetails: ").append(this.getChangeDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChangeRequestExecutionRequest)) {
            return false;
        }
        StartChangeRequestExecutionRequest other = (StartChangeRequestExecutionRequest)obj;
        if (other.getScheduledTime() == null ^ this.getScheduledTime() == null) {
            return false;
        }
        if (other.getScheduledTime() != null && !other.getScheduledTime().equals(this.getScheduledTime())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getChangeRequestName() == null ^ this.getChangeRequestName() == null) {
            return false;
        }
        if (other.getChangeRequestName() != null && !other.getChangeRequestName().equals(this.getChangeRequestName())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRunbooks() == null ^ this.getRunbooks() == null) {
            return false;
        }
        if (other.getRunbooks() != null && !other.getRunbooks().equals(this.getRunbooks())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getScheduledEndTime() == null ^ this.getScheduledEndTime() == null) {
            return false;
        }
        if (other.getScheduledEndTime() != null && !other.getScheduledEndTime().equals(this.getScheduledEndTime())) {
            return false;
        }
        if (other.getChangeDetails() == null ^ this.getChangeDetails() == null) {
            return false;
        }
        return other.getChangeDetails() == null || other.getChangeDetails().equals(this.getChangeDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScheduledTime() == null ? 0 : this.getScheduledTime().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getChangeRequestName() == null ? 0 : this.getChangeRequestName().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRunbooks() == null ? 0 : this.getRunbooks().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledEndTime() == null ? 0 : this.getScheduledEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getChangeDetails() == null ? 0 : this.getChangeDetails().hashCode());
        return hashCode;
    }

    public StartChangeRequestExecutionRequest clone() {
        return (StartChangeRequestExecutionRequest)super.clone();
    }
}

