/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DocumentDescriptionMarshaller {
    private static final MarshallingInfo<String> SHA1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sha1").build();
    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hash").build();
    private static final MarshallingInfo<String> HASHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashType").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> VERSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionName").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusInformation").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").build();
    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").build();
    private static final MarshallingInfo<String> DOCUMENTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentFormat").build();
    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetType").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<List> ATTACHMENTSINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachmentsInformation").build();
    private static final MarshallingInfo<List> REQUIRES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Requires").build();
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Author").build();
    private static final MarshallingInfo<List> REVIEWINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewInformation").build();
    private static final MarshallingInfo<String> APPROVEDVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovedVersion").build();
    private static final MarshallingInfo<String> PENDINGREVIEWVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PendingReviewVersion").build();
    private static final MarshallingInfo<String> REVIEWSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewStatus").build();
    private static final DocumentDescriptionMarshaller instance = new DocumentDescriptionMarshaller();

    public static DocumentDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentDescription documentDescription, ProtocolMarshaller protocolMarshaller) {
        if (documentDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentDescription.getSha1(), SHA1_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getHash(), HASH_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getHashType(), HASHTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getVersionName(), VERSIONNAME_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getCreatedDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getStatusInformation(), STATUSINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getDocumentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(documentDescription.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(documentDescription.getPlatformTypes(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getDocumentType(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getSchemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getLatestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getDefaultVersion(), DEFAULTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getDocumentFormat(), DOCUMENTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getTargetType(), TARGETTYPE_BINDING);
            protocolMarshaller.marshall(documentDescription.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(documentDescription.getAttachmentsInformation(), ATTACHMENTSINFORMATION_BINDING);
            protocolMarshaller.marshall(documentDescription.getRequires(), REQUIRES_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getAuthor(), AUTHOR_BINDING);
            protocolMarshaller.marshall(documentDescription.getReviewInformation(), REVIEWINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getApprovedVersion(), APPROVEDVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getPendingReviewVersion(), PENDINGREVIEWVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.getReviewStatus(), REVIEWSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

