/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.ParameterStringFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetParametersByPathRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String path;
    private Boolean recursive;
    private SdkInternalList<ParameterStringFilter> parameterFilters;
    private Boolean withDecryption;
    private Integer maxResults;
    private String nextToken;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public GetParametersByPathRequest withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public GetParametersByPathRequest withRecursive(Boolean recursive) {
        this.setRecursive(recursive);
        return this;
    }

    public Boolean isRecursive() {
        return this.recursive;
    }

    public List<ParameterStringFilter> getParameterFilters() {
        if (this.parameterFilters == null) {
            this.parameterFilters = new SdkInternalList();
        }
        return this.parameterFilters;
    }

    public void setParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
        if (parameterFilters == null) {
            this.parameterFilters = null;
            return;
        }
        this.parameterFilters = new SdkInternalList(parameterFilters);
    }

    public GetParametersByPathRequest withParameterFilters(ParameterStringFilter ... parameterFilters) {
        if (this.parameterFilters == null) {
            this.setParameterFilters((Collection<ParameterStringFilter>)new SdkInternalList(parameterFilters.length));
        }
        for (ParameterStringFilter ele : parameterFilters) {
            this.parameterFilters.add((Object)ele);
        }
        return this;
    }

    public GetParametersByPathRequest withParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
        this.setParameterFilters(parameterFilters);
        return this;
    }

    public void setWithDecryption(Boolean withDecryption) {
        this.withDecryption = withDecryption;
    }

    public Boolean getWithDecryption() {
        return this.withDecryption;
    }

    public GetParametersByPathRequest withWithDecryption(Boolean withDecryption) {
        this.setWithDecryption(withDecryption);
        return this;
    }

    public Boolean isWithDecryption() {
        return this.withDecryption;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetParametersByPathRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetParametersByPathRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getRecursive() != null) {
            sb.append("Recursive: ").append(this.getRecursive()).append(",");
        }
        if (this.getParameterFilters() != null) {
            sb.append("ParameterFilters: ").append(this.getParameterFilters()).append(",");
        }
        if (this.getWithDecryption() != null) {
            sb.append("WithDecryption: ").append(this.getWithDecryption()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersByPathRequest)) {
            return false;
        }
        GetParametersByPathRequest other = (GetParametersByPathRequest)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getRecursive() == null ^ this.getRecursive() == null) {
            return false;
        }
        if (other.getRecursive() != null && !other.getRecursive().equals(this.getRecursive())) {
            return false;
        }
        if (other.getParameterFilters() == null ^ this.getParameterFilters() == null) {
            return false;
        }
        if (other.getParameterFilters() != null && !other.getParameterFilters().equals(this.getParameterFilters())) {
            return false;
        }
        if (other.getWithDecryption() == null ^ this.getWithDecryption() == null) {
            return false;
        }
        if (other.getWithDecryption() != null && !other.getWithDecryption().equals(this.getWithDecryption())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getRecursive() == null ? 0 : this.getRecursive().hashCode());
        hashCode = 31 * hashCode + (this.getParameterFilters() == null ? 0 : this.getParameterFilters().hashCode());
        hashCode = 31 * hashCode + (this.getWithDecryption() == null ? 0 : this.getWithDecryption().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetParametersByPathRequest clone() {
        return (GetParametersByPathRequest)super.clone();
    }
}

