/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFormat;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentRequires;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentType;
import com.amazonaws.services.simplesystemsmanagement.model.PlatformType;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentIdentifierMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DocumentIdentifier
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String owner;
    private String versionName;
    private SdkInternalList<String> platformTypes;
    private String documentVersion;
    private String documentType;
    private String schemaVersion;
    private String documentFormat;
    private String targetType;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<DocumentRequires> requires;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentIdentifier withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public DocumentIdentifier withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public DocumentIdentifier withVersionName(String versionName) {
        this.setVersionName(versionName);
        return this;
    }

    public List<String> getPlatformTypes() {
        if (this.platformTypes == null) {
            this.platformTypes = new SdkInternalList();
        }
        return this.platformTypes;
    }

    public void setPlatformTypes(Collection<String> platformTypes) {
        if (platformTypes == null) {
            this.platformTypes = null;
            return;
        }
        this.platformTypes = new SdkInternalList(platformTypes);
    }

    public DocumentIdentifier withPlatformTypes(String ... platformTypes) {
        if (this.platformTypes == null) {
            this.setPlatformTypes((Collection<String>)new SdkInternalList(platformTypes.length));
        }
        for (String ele : platformTypes) {
            this.platformTypes.add((Object)ele);
        }
        return this;
    }

    public DocumentIdentifier withPlatformTypes(Collection<String> platformTypes) {
        this.setPlatformTypes(platformTypes);
        return this;
    }

    public DocumentIdentifier withPlatformTypes(PlatformType ... platformTypes) {
        SdkInternalList platformTypesCopy = new SdkInternalList(platformTypes.length);
        for (PlatformType value : platformTypes) {
            platformTypesCopy.add((Object)value.toString());
        }
        if (this.getPlatformTypes() == null) {
            this.setPlatformTypes((Collection<String>)platformTypesCopy);
        } else {
            this.getPlatformTypes().addAll((Collection<String>)platformTypesCopy);
        }
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public DocumentIdentifier withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public DocumentIdentifier withDocumentType(String documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    public void setDocumentType(DocumentType documentType) {
        this.withDocumentType(documentType);
    }

    public DocumentIdentifier withDocumentType(DocumentType documentType) {
        this.documentType = documentType.toString();
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public DocumentIdentifier withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public void setDocumentFormat(String documentFormat) {
        this.documentFormat = documentFormat;
    }

    public String getDocumentFormat() {
        return this.documentFormat;
    }

    public DocumentIdentifier withDocumentFormat(String documentFormat) {
        this.setDocumentFormat(documentFormat);
        return this;
    }

    public void setDocumentFormat(DocumentFormat documentFormat) {
        this.withDocumentFormat(documentFormat);
    }

    public DocumentIdentifier withDocumentFormat(DocumentFormat documentFormat) {
        this.documentFormat = documentFormat.toString();
        return this;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public DocumentIdentifier withTargetType(String targetType) {
        this.setTargetType(targetType);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public DocumentIdentifier withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public DocumentIdentifier withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<DocumentRequires> getRequires() {
        if (this.requires == null) {
            this.requires = new SdkInternalList();
        }
        return this.requires;
    }

    public void setRequires(Collection<DocumentRequires> requires) {
        if (requires == null) {
            this.requires = null;
            return;
        }
        this.requires = new SdkInternalList(requires);
    }

    public DocumentIdentifier withRequires(DocumentRequires ... requires) {
        if (this.requires == null) {
            this.setRequires((Collection<DocumentRequires>)new SdkInternalList(requires.length));
        }
        for (DocumentRequires ele : requires) {
            this.requires.add((Object)ele);
        }
        return this;
    }

    public DocumentIdentifier withRequires(Collection<DocumentRequires> requires) {
        this.setRequires(requires);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getVersionName() != null) {
            sb.append("VersionName: ").append(this.getVersionName()).append(",");
        }
        if (this.getPlatformTypes() != null) {
            sb.append("PlatformTypes: ").append(this.getPlatformTypes()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getDocumentType() != null) {
            sb.append("DocumentType: ").append(this.getDocumentType()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion()).append(",");
        }
        if (this.getDocumentFormat() != null) {
            sb.append("DocumentFormat: ").append(this.getDocumentFormat()).append(",");
        }
        if (this.getTargetType() != null) {
            sb.append("TargetType: ").append(this.getTargetType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getRequires() != null) {
            sb.append("Requires: ").append(this.getRequires());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getVersionName() == null ^ this.getVersionName() == null) {
            return false;
        }
        if (other.getVersionName() != null && !other.getVersionName().equals(this.getVersionName())) {
            return false;
        }
        if (other.getPlatformTypes() == null ^ this.getPlatformTypes() == null) {
            return false;
        }
        if (other.getPlatformTypes() != null && !other.getPlatformTypes().equals(this.getPlatformTypes())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getDocumentType() == null ^ this.getDocumentType() == null) {
            return false;
        }
        if (other.getDocumentType() != null && !other.getDocumentType().equals(this.getDocumentType())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        if (other.getSchemaVersion() != null && !other.getSchemaVersion().equals(this.getSchemaVersion())) {
            return false;
        }
        if (other.getDocumentFormat() == null ^ this.getDocumentFormat() == null) {
            return false;
        }
        if (other.getDocumentFormat() != null && !other.getDocumentFormat().equals(this.getDocumentFormat())) {
            return false;
        }
        if (other.getTargetType() == null ^ this.getTargetType() == null) {
            return false;
        }
        if (other.getTargetType() != null && !other.getTargetType().equals(this.getTargetType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getRequires() == null ^ this.getRequires() == null) {
            return false;
        }
        return other.getRequires() == null || other.getRequires().equals(this.getRequires());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getVersionName() == null ? 0 : this.getVersionName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformTypes() == null ? 0 : this.getPlatformTypes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentType() == null ? 0 : this.getDocumentType().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentFormat() == null ? 0 : this.getDocumentFormat().hashCode());
        hashCode = 31 * hashCode + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getRequires() == null ? 0 : this.getRequires().hashCode());
        return hashCode;
    }

    public DocumentIdentifier clone() {
        try {
            return (DocumentIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

