/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.PatchComplianceLevel;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdatePatchBaselineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String baselineId;
    private String name;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private String approvedPatchesComplianceLevel;
    private SdkInternalList<String> rejectedPatches;
    private String description;

    public void setBaselineId(String baselineId) {
        this.baselineId = baselineId;
    }

    public String getBaselineId() {
        return this.baselineId;
    }

    public UpdatePatchBaselineRequest withBaselineId(String baselineId) {
        this.setBaselineId(baselineId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdatePatchBaselineRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public UpdatePatchBaselineRequest withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public UpdatePatchBaselineRequest withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList(approvedPatches);
    }

    public UpdatePatchBaselineRequest withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches((Collection<String>)new SdkInternalList(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add((Object)ele);
        }
        return this;
    }

    public UpdatePatchBaselineRequest withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
    }

    public String getApprovedPatchesComplianceLevel() {
        return this.approvedPatchesComplianceLevel;
    }

    public UpdatePatchBaselineRequest withApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.withApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
    }

    public UpdatePatchBaselineRequest withApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel.toString();
        return this;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList(rejectedPatches);
    }

    public UpdatePatchBaselineRequest withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches((Collection<String>)new SdkInternalList(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add((Object)ele);
        }
        return this;
    }

    public UpdatePatchBaselineRequest withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdatePatchBaselineRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaselineId() != null) {
            sb.append("BaselineId: ").append(this.getBaselineId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.getGlobalFilters()).append(",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: ").append(this.getApprovalRules()).append(",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.getApprovedPatches()).append(",");
        }
        if (this.getApprovedPatchesComplianceLevel() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.getApprovedPatchesComplianceLevel()).append(",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.getRejectedPatches()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineRequest)) {
            return false;
        }
        UpdatePatchBaselineRequest other = (UpdatePatchBaselineRequest)obj;
        if (other.getBaselineId() == null ^ this.getBaselineId() == null) {
            return false;
        }
        if (other.getBaselineId() != null && !other.getBaselineId().equals(this.getBaselineId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() == null ^ this.getApprovedPatchesComplianceLevel() == null) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() != null && !other.getApprovedPatchesComplianceLevel().equals(this.getApprovedPatchesComplianceLevel())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaselineId() == null ? 0 : this.getBaselineId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesComplianceLevel() == null ? 0 : this.getApprovedPatchesComplianceLevel().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public UpdatePatchBaselineRequest clone() {
        return (UpdatePatchBaselineRequest)super.clone();
    }
}

