/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListDocumentsRequestMarshaller
implements Marshaller<Request<ListDocumentsRequest>, ListDocumentsRequest> {
    public Request<ListDocumentsRequest> marshall(ListDocumentsRequest listDocumentsRequest) {
        if (listDocumentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDocumentsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListDocuments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList documentFilterListList = (SdkInternalList)listDocumentsRequest.getDocumentFilterList();
            if (!documentFilterListList.isEmpty() || !documentFilterListList.isAutoConstruct()) {
                jsonWriter.key("DocumentFilterList");
                jsonWriter.array();
                for (DocumentFilter documentFilterListListValue : documentFilterListList) {
                    if (documentFilterListListValue == null) continue;
                    DocumentFilterJsonMarshaller.getInstance().marshall(documentFilterListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (listDocumentsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value((Object)listDocumentsRequest.getMaxResults());
            }
            if (listDocumentsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)listDocumentsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

