/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.MessageSystemAttributeValue;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MessageSystemAttributeValueStaxUnmarshaller
implements Unmarshaller<MessageSystemAttributeValue, StaxUnmarshallerContext> {
    private static MessageSystemAttributeValueStaxUnmarshaller instance;

    public MessageSystemAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageSystemAttributeValue messageSystemAttributeValue = new MessageSystemAttributeValue();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return messageSystemAttributeValue;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StringValue", targetDepth)) {
                    messageSystemAttributeValue.setStringValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    messageSystemAttributeValue.setBinaryValue(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StringListValue", targetDepth)) {
                    messageSystemAttributeValue.withStringListValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryListValue", targetDepth)) {
                    messageSystemAttributeValue.withBinaryListValues(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DataType", targetDepth)) continue;
                messageSystemAttributeValue.setDataType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return messageSystemAttributeValue;
    }

    public static MessageSystemAttributeValueStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageSystemAttributeValueStaxUnmarshaller();
        }
        return instance;
    }
}

