/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        if (sendMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)sendMessageRequest.getQueueUrl()));
        }
        if (sendMessageRequest.getMessageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString((String)sendMessageRequest.getMessageBody()));
        }
        if (sendMessageRequest.getDelaySeconds() != null) {
            request.addParameter("DelaySeconds", StringUtils.fromInteger((Integer)sendMessageRequest.getDelaySeconds()));
        }
        if (sendMessageRequest != null && sendMessageRequest.getMessageAttributes() != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> messageAttributesListValue : sendMessageRequest.getMessageAttributes().entrySet()) {
                MessageAttributeValue messageAttributeValueValue;
                if (messageAttributesListValue.getKey() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)messageAttributesListValue.getKey()));
                }
                if ((messageAttributeValueValue = messageAttributesListValue.getValue()) != null) {
                    if (messageAttributeValueValue.getStringValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)messageAttributeValueValue.getStringValue()));
                    }
                    if (messageAttributeValueValue.getBinaryValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)messageAttributeValueValue.getBinaryValue()));
                    }
                    List<String> stringListValuesList = messageAttributeValueValue.getStringListValues();
                    int stringListValuesListIndex = 1;
                    for (String stringListValuesListValue : stringListValuesList) {
                        if (stringListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString((String)stringListValuesListValue));
                        }
                        ++stringListValuesListIndex;
                    }
                    List<ByteBuffer> binaryListValuesList = messageAttributeValueValue.getBinaryListValues();
                    int binaryListValuesListIndex = 1;
                    for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                        if (binaryListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesListValue));
                        }
                        ++binaryListValuesListIndex;
                    }
                    if (messageAttributeValueValue.getDataType() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)messageAttributeValueValue.getDataType()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        return request;
    }
}

