/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.snowball.AmazonSnowballAsync;
import com.amazonaws.services.snowball.AmazonSnowballAsyncClientBuilder;
import com.amazonaws.services.snowball.AmazonSnowballClient;
import com.amazonaws.services.snowball.model.CancelClusterRequest;
import com.amazonaws.services.snowball.model.CancelClusterResult;
import com.amazonaws.services.snowball.model.CancelJobRequest;
import com.amazonaws.services.snowball.model.CancelJobResult;
import com.amazonaws.services.snowball.model.CreateAddressRequest;
import com.amazonaws.services.snowball.model.CreateAddressResult;
import com.amazonaws.services.snowball.model.CreateClusterRequest;
import com.amazonaws.services.snowball.model.CreateClusterResult;
import com.amazonaws.services.snowball.model.CreateJobRequest;
import com.amazonaws.services.snowball.model.CreateJobResult;
import com.amazonaws.services.snowball.model.DescribeAddressRequest;
import com.amazonaws.services.snowball.model.DescribeAddressResult;
import com.amazonaws.services.snowball.model.DescribeAddressesRequest;
import com.amazonaws.services.snowball.model.DescribeAddressesResult;
import com.amazonaws.services.snowball.model.DescribeClusterRequest;
import com.amazonaws.services.snowball.model.DescribeClusterResult;
import com.amazonaws.services.snowball.model.DescribeJobRequest;
import com.amazonaws.services.snowball.model.DescribeJobResult;
import com.amazonaws.services.snowball.model.GetJobManifestRequest;
import com.amazonaws.services.snowball.model.GetJobManifestResult;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeRequest;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeResult;
import com.amazonaws.services.snowball.model.GetSnowballUsageRequest;
import com.amazonaws.services.snowball.model.GetSnowballUsageResult;
import com.amazonaws.services.snowball.model.GetSoftwareUpdatesRequest;
import com.amazonaws.services.snowball.model.GetSoftwareUpdatesResult;
import com.amazonaws.services.snowball.model.ListClusterJobsRequest;
import com.amazonaws.services.snowball.model.ListClusterJobsResult;
import com.amazonaws.services.snowball.model.ListClustersRequest;
import com.amazonaws.services.snowball.model.ListClustersResult;
import com.amazonaws.services.snowball.model.ListCompatibleImagesRequest;
import com.amazonaws.services.snowball.model.ListCompatibleImagesResult;
import com.amazonaws.services.snowball.model.ListJobsRequest;
import com.amazonaws.services.snowball.model.ListJobsResult;
import com.amazonaws.services.snowball.model.UpdateClusterRequest;
import com.amazonaws.services.snowball.model.UpdateClusterResult;
import com.amazonaws.services.snowball.model.UpdateJobRequest;
import com.amazonaws.services.snowball.model.UpdateJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSnowballAsyncClient
extends AmazonSnowballClient
implements AmazonSnowballAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonSnowballAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonSnowballAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonSnowballAsyncClientBuilder asyncBuilder() {
        return AmazonSnowballAsyncClientBuilder.standard();
    }

    AmazonSnowballAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSnowballAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelClusterResult> cancelClusterAsync(CancelClusterRequest request) {
        return this.cancelClusterAsync(request, null);
    }

    @Override
    public Future<CancelClusterResult> cancelClusterAsync(CancelClusterRequest request, final AsyncHandler<CancelClusterRequest, CancelClusterResult> asyncHandler) {
        final CancelClusterRequest finalRequest = (CancelClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelClusterResult>(){

            @Override
            public CancelClusterResult call() throws Exception {
                CancelClusterResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeCancelCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAddressResult> createAddressAsync(CreateAddressRequest request) {
        return this.createAddressAsync(request, null);
    }

    @Override
    public Future<CreateAddressResult> createAddressAsync(CreateAddressRequest request, final AsyncHandler<CreateAddressRequest, CreateAddressResult> asyncHandler) {
        final CreateAddressRequest finalRequest = (CreateAddressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAddressResult>(){

            @Override
            public CreateAddressResult call() throws Exception {
                CreateAddressResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeCreateAddress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddressResult> describeAddressAsync(DescribeAddressRequest request) {
        return this.describeAddressAsync(request, null);
    }

    @Override
    public Future<DescribeAddressResult> describeAddressAsync(DescribeAddressRequest request, final AsyncHandler<DescribeAddressRequest, DescribeAddressResult> asyncHandler) {
        final DescribeAddressRequest finalRequest = (DescribeAddressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAddressResult>(){

            @Override
            public DescribeAddressResult call() throws Exception {
                DescribeAddressResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeDescribeAddress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(DescribeAddressesRequest request) {
        return this.describeAddressesAsync(request, null);
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(DescribeAddressesRequest request, final AsyncHandler<DescribeAddressesRequest, DescribeAddressesResult> asyncHandler) {
        final DescribeAddressesRequest finalRequest = (DescribeAddressesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAddressesResult>(){

            @Override
            public DescribeAddressesResult call() throws Exception {
                DescribeAddressesResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeDescribeAddresses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        final DescribeClusterRequest finalRequest = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeDescribeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request) {
        return this.describeJobAsync(request, null);
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request, final AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) {
        final DescribeJobRequest finalRequest = (DescribeJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeDescribeJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobManifestResult> getJobManifestAsync(GetJobManifestRequest request) {
        return this.getJobManifestAsync(request, null);
    }

    @Override
    public Future<GetJobManifestResult> getJobManifestAsync(GetJobManifestRequest request, final AsyncHandler<GetJobManifestRequest, GetJobManifestResult> asyncHandler) {
        final GetJobManifestRequest finalRequest = (GetJobManifestRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobManifestResult>(){

            @Override
            public GetJobManifestResult call() throws Exception {
                GetJobManifestResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeGetJobManifest(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobUnlockCodeResult> getJobUnlockCodeAsync(GetJobUnlockCodeRequest request) {
        return this.getJobUnlockCodeAsync(request, null);
    }

    @Override
    public Future<GetJobUnlockCodeResult> getJobUnlockCodeAsync(GetJobUnlockCodeRequest request, final AsyncHandler<GetJobUnlockCodeRequest, GetJobUnlockCodeResult> asyncHandler) {
        final GetJobUnlockCodeRequest finalRequest = (GetJobUnlockCodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobUnlockCodeResult>(){

            @Override
            public GetJobUnlockCodeResult call() throws Exception {
                GetJobUnlockCodeResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeGetJobUnlockCode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSnowballUsageResult> getSnowballUsageAsync(GetSnowballUsageRequest request) {
        return this.getSnowballUsageAsync(request, null);
    }

    @Override
    public Future<GetSnowballUsageResult> getSnowballUsageAsync(GetSnowballUsageRequest request, final AsyncHandler<GetSnowballUsageRequest, GetSnowballUsageResult> asyncHandler) {
        final GetSnowballUsageRequest finalRequest = (GetSnowballUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSnowballUsageResult>(){

            @Override
            public GetSnowballUsageResult call() throws Exception {
                GetSnowballUsageResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeGetSnowballUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSoftwareUpdatesResult> getSoftwareUpdatesAsync(GetSoftwareUpdatesRequest request) {
        return this.getSoftwareUpdatesAsync(request, null);
    }

    @Override
    public Future<GetSoftwareUpdatesResult> getSoftwareUpdatesAsync(GetSoftwareUpdatesRequest request, final AsyncHandler<GetSoftwareUpdatesRequest, GetSoftwareUpdatesResult> asyncHandler) {
        final GetSoftwareUpdatesRequest finalRequest = (GetSoftwareUpdatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSoftwareUpdatesResult>(){

            @Override
            public GetSoftwareUpdatesResult call() throws Exception {
                GetSoftwareUpdatesResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeGetSoftwareUpdates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClusterJobsResult> listClusterJobsAsync(ListClusterJobsRequest request) {
        return this.listClusterJobsAsync(request, null);
    }

    @Override
    public Future<ListClusterJobsResult> listClusterJobsAsync(ListClusterJobsRequest request, final AsyncHandler<ListClusterJobsRequest, ListClusterJobsResult> asyncHandler) {
        final ListClusterJobsRequest finalRequest = (ListClusterJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClusterJobsResult>(){

            @Override
            public ListClusterJobsResult call() throws Exception {
                ListClusterJobsResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeListClusterJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCompatibleImagesResult> listCompatibleImagesAsync(ListCompatibleImagesRequest request) {
        return this.listCompatibleImagesAsync(request, null);
    }

    @Override
    public Future<ListCompatibleImagesResult> listCompatibleImagesAsync(ListCompatibleImagesRequest request, final AsyncHandler<ListCompatibleImagesRequest, ListCompatibleImagesResult> asyncHandler) {
        final ListCompatibleImagesRequest finalRequest = (ListCompatibleImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCompatibleImagesResult>(){

            @Override
            public ListCompatibleImagesResult call() throws Exception {
                ListCompatibleImagesResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeListCompatibleImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterAsync(request, null);
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request, final AsyncHandler<UpdateClusterRequest, UpdateClusterResult> asyncHandler) {
        final UpdateClusterRequest finalRequest = (UpdateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterResult>(){

            @Override
            public UpdateClusterResult call() throws Exception {
                UpdateClusterResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeUpdateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request) {
        return this.updateJobAsync(request, null);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request, final AsyncHandler<UpdateJobRequest, UpdateJobResult> asyncHandler) {
        final UpdateJobRequest finalRequest = (UpdateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobResult>(){

            @Override
            public UpdateJobResult call() throws Exception {
                UpdateJobResult result = null;
                try {
                    result = AmazonSnowballAsyncClient.this.executeUpdateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

