/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.DataTransfer;

public class DataTransferJsonMarshaller {
    private static DataTransferJsonMarshaller instance;

    public void marshall(DataTransfer dataTransfer, StructuredJsonGenerator jsonGenerator) {
        if (dataTransfer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dataTransfer.getBytesTransferred() != null) {
                jsonGenerator.writeFieldName("BytesTransferred").writeValue(dataTransfer.getBytesTransferred().longValue());
            }
            if (dataTransfer.getObjectsTransferred() != null) {
                jsonGenerator.writeFieldName("ObjectsTransferred").writeValue(dataTransfer.getObjectsTransferred().longValue());
            }
            if (dataTransfer.getTotalBytes() != null) {
                jsonGenerator.writeFieldName("TotalBytes").writeValue(dataTransfer.getTotalBytes().longValue());
            }
            if (dataTransfer.getTotalObjects() != null) {
                jsonGenerator.writeFieldName("TotalObjects").writeValue(dataTransfer.getTotalObjects().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataTransferJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataTransferJsonMarshaller();
        }
        return instance;
    }
}

