/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simpleworkflow.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Input data for a TaskCompleted response to a decision task.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/RespondDecisionTaskCompleted" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RespondDecisionTaskCompletedRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     */
    private String taskToken;
    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     */
    private java.util.List<Decision> decisions;
    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     */
    private String executionContext;
    /**
     * <p>
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original
     * task list you specified while starting the workflow execution.
     * </p>
     */
    private TaskList taskList;
    /**
     * <p>
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task
     * scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon
     * SWF will revert the override and schedule a new decision task to the original task list.
     * </p>
     * <p>
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within
     * the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the
     * original task list.
     * </p>
     */
    private String taskListScheduleToStartTimeout;

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @param taskToken
     *        The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
     *        <p>
     *        <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *        is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *        its progress and respond with results.
     *        </p>
     */

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @return The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
     *         <p>
     *         <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *         is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *         its progress and respond with results.
     *         </p>
     */

    public String getTaskToken() {
        return this.taskToken;
    }

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @param taskToken
     *        The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
     *        <p>
     *        <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *        is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *        its progress and respond with results.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withTaskToken(String taskToken) {
        setTaskToken(taskToken);
        return this;
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * 
     * @return The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *         docs for the <a>Decision</a> structure for details.
     */

    public java.util.List<Decision> getDecisions() {
        return decisions;
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * 
     * @param decisions
     *        The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *        docs for the <a>Decision</a> structure for details.
     */

    public void setDecisions(java.util.Collection<Decision> decisions) {
        if (decisions == null) {
            this.decisions = null;
            return;
        }

        this.decisions = new java.util.ArrayList<Decision>(decisions);
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDecisions(java.util.Collection)} or {@link #withDecisions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param decisions
     *        The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *        docs for the <a>Decision</a> structure for details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withDecisions(Decision... decisions) {
        if (this.decisions == null) {
            setDecisions(new java.util.ArrayList<Decision>(decisions.length));
        }
        for (Decision ele : decisions) {
            this.decisions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * 
     * @param decisions
     *        The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *        docs for the <a>Decision</a> structure for details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withDecisions(java.util.Collection<Decision> decisions) {
        setDecisions(decisions);
        return this;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @param executionContext
     *        User defined context to add to workflow execution.
     */

    public void setExecutionContext(String executionContext) {
        this.executionContext = executionContext;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @return User defined context to add to workflow execution.
     */

    public String getExecutionContext() {
        return this.executionContext;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @param executionContext
     *        User defined context to add to workflow execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withExecutionContext(String executionContext) {
        setExecutionContext(executionContext);
        return this;
    }

    /**
     * <p>
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original
     * task list you specified while starting the workflow execution.
     * </p>
     * 
     * @param taskList
     *        The task list to use for the future decision tasks of this workflow execution. This list overrides the
     *        original task list you specified while starting the workflow execution.
     */

    public void setTaskList(TaskList taskList) {
        this.taskList = taskList;
    }

    /**
     * <p>
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original
     * task list you specified while starting the workflow execution.
     * </p>
     * 
     * @return The task list to use for the future decision tasks of this workflow execution. This list overrides the
     *         original task list you specified while starting the workflow execution.
     */

    public TaskList getTaskList() {
        return this.taskList;
    }

    /**
     * <p>
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original
     * task list you specified while starting the workflow execution.
     * </p>
     * 
     * @param taskList
     *        The task list to use for the future decision tasks of this workflow execution. This list overrides the
     *        original task list you specified while starting the workflow execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withTaskList(TaskList taskList) {
        setTaskList(taskList);
        return this;
    }

    /**
     * <p>
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task
     * scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon
     * SWF will revert the override and schedule a new decision task to the original task list.
     * </p>
     * <p>
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within
     * the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the
     * original task list.
     * </p>
     * 
     * @param taskListScheduleToStartTimeout
     *        Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     *        override is permanent. This parameter makes it possible to temporarily override the task list. If a
     *        decision task scheduled on the override task list is not started within the timeout, the decision task
     *        will time out. Amazon SWF will revert the override and schedule a new decision task to the original task
     *        list.</p>
     *        <p>
     *        If a decision task scheduled on the override task list is started within the timeout, but not completed
     *        within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision
     *        task to the original task list.
     */

    public void setTaskListScheduleToStartTimeout(String taskListScheduleToStartTimeout) {
        this.taskListScheduleToStartTimeout = taskListScheduleToStartTimeout;
    }

    /**
     * <p>
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task
     * scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon
     * SWF will revert the override and schedule a new decision task to the original task list.
     * </p>
     * <p>
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within
     * the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the
     * original task list.
     * </p>
     * 
     * @return Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task
     *         list override is permanent. This parameter makes it possible to temporarily override the task list. If a
     *         decision task scheduled on the override task list is not started within the timeout, the decision task
     *         will time out. Amazon SWF will revert the override and schedule a new decision task to the original task
     *         list.</p>
     *         <p>
     *         If a decision task scheduled on the override task list is started within the timeout, but not completed
     *         within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision
     *         task to the original task list.
     */

    public String getTaskListScheduleToStartTimeout() {
        return this.taskListScheduleToStartTimeout;
    }

    /**
     * <p>
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task
     * scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon
     * SWF will revert the override and schedule a new decision task to the original task list.
     * </p>
     * <p>
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within
     * the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the
     * original task list.
     * </p>
     * 
     * @param taskListScheduleToStartTimeout
     *        Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     *        override is permanent. This parameter makes it possible to temporarily override the task list. If a
     *        decision task scheduled on the override task list is not started within the timeout, the decision task
     *        will time out. Amazon SWF will revert the override and schedule a new decision task to the original task
     *        list.</p>
     *        <p>
     *        If a decision task scheduled on the override task list is started within the timeout, but not completed
     *        within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision
     *        task to the original task list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RespondDecisionTaskCompletedRequest withTaskListScheduleToStartTimeout(String taskListScheduleToStartTimeout) {
        setTaskListScheduleToStartTimeout(taskListScheduleToStartTimeout);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTaskToken() != null)
            sb.append("TaskToken: ").append(getTaskToken()).append(",");
        if (getDecisions() != null)
            sb.append("Decisions: ").append(getDecisions()).append(",");
        if (getExecutionContext() != null)
            sb.append("ExecutionContext: ").append(getExecutionContext()).append(",");
        if (getTaskList() != null)
            sb.append("TaskList: ").append(getTaskList()).append(",");
        if (getTaskListScheduleToStartTimeout() != null)
            sb.append("TaskListScheduleToStartTimeout: ").append(getTaskListScheduleToStartTimeout());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RespondDecisionTaskCompletedRequest == false)
            return false;
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest) obj;
        if (other.getTaskToken() == null ^ this.getTaskToken() == null)
            return false;
        if (other.getTaskToken() != null && other.getTaskToken().equals(this.getTaskToken()) == false)
            return false;
        if (other.getDecisions() == null ^ this.getDecisions() == null)
            return false;
        if (other.getDecisions() != null && other.getDecisions().equals(this.getDecisions()) == false)
            return false;
        if (other.getExecutionContext() == null ^ this.getExecutionContext() == null)
            return false;
        if (other.getExecutionContext() != null && other.getExecutionContext().equals(this.getExecutionContext()) == false)
            return false;
        if (other.getTaskList() == null ^ this.getTaskList() == null)
            return false;
        if (other.getTaskList() != null && other.getTaskList().equals(this.getTaskList()) == false)
            return false;
        if (other.getTaskListScheduleToStartTimeout() == null ^ this.getTaskListScheduleToStartTimeout() == null)
            return false;
        if (other.getTaskListScheduleToStartTimeout() != null
                && other.getTaskListScheduleToStartTimeout().equals(this.getTaskListScheduleToStartTimeout()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTaskToken() == null) ? 0 : getTaskToken().hashCode());
        hashCode = prime * hashCode + ((getDecisions() == null) ? 0 : getDecisions().hashCode());
        hashCode = prime * hashCode + ((getExecutionContext() == null) ? 0 : getExecutionContext().hashCode());
        hashCode = prime * hashCode + ((getTaskList() == null) ? 0 : getTaskList().hashCode());
        hashCode = prime * hashCode + ((getTaskListScheduleToStartTimeout() == null) ? 0 : getTaskListScheduleToStartTimeout().hashCode());
        return hashCode;
    }

    @Override
    public RespondDecisionTaskCompletedRequest clone() {
        return (RespondDecisionTaskCompletedRequest) super.clone();
    }

}
