/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowAsync;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSimpleWorkflowAsyncClient
extends AmazonSimpleWorkflowClient
implements AmazonSimpleWorkflowAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonSimpleWorkflowAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSimpleWorkflowAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleWorkflowAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<WorkflowExecutionCount> countClosedWorkflowExecutionsAsync(CountClosedWorkflowExecutionsRequest request) {
        return this.countClosedWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionCount> countClosedWorkflowExecutionsAsync(final CountClosedWorkflowExecutionsRequest request, final AsyncHandler<CountClosedWorkflowExecutionsRequest, WorkflowExecutionCount> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                WorkflowExecutionCount result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.countClosedWorkflowExecutions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionCount> countOpenWorkflowExecutionsAsync(CountOpenWorkflowExecutionsRequest request) {
        return this.countOpenWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionCount> countOpenWorkflowExecutionsAsync(final CountOpenWorkflowExecutionsRequest request, final AsyncHandler<CountOpenWorkflowExecutionsRequest, WorkflowExecutionCount> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                WorkflowExecutionCount result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.countOpenWorkflowExecutions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingActivityTasksAsync(CountPendingActivityTasksRequest request) {
        return this.countPendingActivityTasksAsync(request, null);
    }

    @Override
    public Future<PendingTaskCount> countPendingActivityTasksAsync(final CountPendingActivityTasksRequest request, final AsyncHandler<CountPendingActivityTasksRequest, PendingTaskCount> asyncHandler) {
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                PendingTaskCount result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.countPendingActivityTasks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingDecisionTasksAsync(CountPendingDecisionTasksRequest request) {
        return this.countPendingDecisionTasksAsync(request, null);
    }

    @Override
    public Future<PendingTaskCount> countPendingDecisionTasksAsync(final CountPendingDecisionTasksRequest request, final AsyncHandler<CountPendingDecisionTasksRequest, PendingTaskCount> asyncHandler) {
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                PendingTaskCount result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.countPendingDecisionTasks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateActivityTypeAsync(DeprecateActivityTypeRequest request) {
        return this.deprecateActivityTypeAsync(request, null);
    }

    @Override
    public Future<Void> deprecateActivityTypeAsync(final DeprecateActivityTypeRequest request, final AsyncHandler<DeprecateActivityTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.deprecateActivityType(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateDomainAsync(DeprecateDomainRequest request) {
        return this.deprecateDomainAsync(request, null);
    }

    @Override
    public Future<Void> deprecateDomainAsync(final DeprecateDomainRequest request, final AsyncHandler<DeprecateDomainRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.deprecateDomain(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateWorkflowTypeAsync(DeprecateWorkflowTypeRequest request) {
        return this.deprecateWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<Void> deprecateWorkflowTypeAsync(final DeprecateWorkflowTypeRequest request, final AsyncHandler<DeprecateWorkflowTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.deprecateWorkflowType(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTypeDetail> describeActivityTypeAsync(DescribeActivityTypeRequest request) {
        return this.describeActivityTypeAsync(request, null);
    }

    @Override
    public Future<ActivityTypeDetail> describeActivityTypeAsync(final DescribeActivityTypeRequest request, final AsyncHandler<DescribeActivityTypeRequest, ActivityTypeDetail> asyncHandler) {
        return this.executorService.submit(new Callable<ActivityTypeDetail>(){

            @Override
            public ActivityTypeDetail call() throws Exception {
                ActivityTypeDetail result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.describeActivityType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DomainDetail> describeDomainAsync(DescribeDomainRequest request) {
        return this.describeDomainAsync(request, null);
    }

    @Override
    public Future<DomainDetail> describeDomainAsync(final DescribeDomainRequest request, final AsyncHandler<DescribeDomainRequest, DomainDetail> asyncHandler) {
        return this.executorService.submit(new Callable<DomainDetail>(){

            @Override
            public DomainDetail call() throws Exception {
                DomainDetail result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.describeDomain(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionDetail> describeWorkflowExecutionAsync(DescribeWorkflowExecutionRequest request) {
        return this.describeWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionDetail> describeWorkflowExecutionAsync(final DescribeWorkflowExecutionRequest request, final AsyncHandler<DescribeWorkflowExecutionRequest, WorkflowExecutionDetail> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowExecutionDetail>(){

            @Override
            public WorkflowExecutionDetail call() throws Exception {
                WorkflowExecutionDetail result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.describeWorkflowExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowTypeDetail> describeWorkflowTypeAsync(DescribeWorkflowTypeRequest request) {
        return this.describeWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<WorkflowTypeDetail> describeWorkflowTypeAsync(final DescribeWorkflowTypeRequest request, final AsyncHandler<DescribeWorkflowTypeRequest, WorkflowTypeDetail> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowTypeDetail>(){

            @Override
            public WorkflowTypeDetail call() throws Exception {
                WorkflowTypeDetail result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.describeWorkflowType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<History> getWorkflowExecutionHistoryAsync(GetWorkflowExecutionHistoryRequest request) {
        return this.getWorkflowExecutionHistoryAsync(request, null);
    }

    @Override
    public Future<History> getWorkflowExecutionHistoryAsync(final GetWorkflowExecutionHistoryRequest request, final AsyncHandler<GetWorkflowExecutionHistoryRequest, History> asyncHandler) {
        return this.executorService.submit(new Callable<History>(){

            @Override
            public History call() throws Exception {
                History result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.getWorkflowExecutionHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTypeInfos> listActivityTypesAsync(ListActivityTypesRequest request) {
        return this.listActivityTypesAsync(request, null);
    }

    @Override
    public Future<ActivityTypeInfos> listActivityTypesAsync(final ListActivityTypesRequest request, final AsyncHandler<ListActivityTypesRequest, ActivityTypeInfos> asyncHandler) {
        return this.executorService.submit(new Callable<ActivityTypeInfos>(){

            @Override
            public ActivityTypeInfos call() throws Exception {
                ActivityTypeInfos result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.listActivityTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listClosedWorkflowExecutionsAsync(ListClosedWorkflowExecutionsRequest request) {
        return this.listClosedWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionInfos> listClosedWorkflowExecutionsAsync(final ListClosedWorkflowExecutionsRequest request, final AsyncHandler<ListClosedWorkflowExecutionsRequest, WorkflowExecutionInfos> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                WorkflowExecutionInfos result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.listClosedWorkflowExecutions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DomainInfos> listDomainsAsync(ListDomainsRequest request) {
        return this.listDomainsAsync(request, null);
    }

    @Override
    public Future<DomainInfos> listDomainsAsync(final ListDomainsRequest request, final AsyncHandler<ListDomainsRequest, DomainInfos> asyncHandler) {
        return this.executorService.submit(new Callable<DomainInfos>(){

            @Override
            public DomainInfos call() throws Exception {
                DomainInfos result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.listDomains(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listOpenWorkflowExecutionsAsync(ListOpenWorkflowExecutionsRequest request) {
        return this.listOpenWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionInfos> listOpenWorkflowExecutionsAsync(final ListOpenWorkflowExecutionsRequest request, final AsyncHandler<ListOpenWorkflowExecutionsRequest, WorkflowExecutionInfos> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                WorkflowExecutionInfos result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.listOpenWorkflowExecutions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowTypeInfos> listWorkflowTypesAsync(ListWorkflowTypesRequest request) {
        return this.listWorkflowTypesAsync(request, null);
    }

    @Override
    public Future<WorkflowTypeInfos> listWorkflowTypesAsync(final ListWorkflowTypesRequest request, final AsyncHandler<ListWorkflowTypesRequest, WorkflowTypeInfos> asyncHandler) {
        return this.executorService.submit(new Callable<WorkflowTypeInfos>(){

            @Override
            public WorkflowTypeInfos call() throws Exception {
                WorkflowTypeInfos result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.listWorkflowTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTask> pollForActivityTaskAsync(PollForActivityTaskRequest request) {
        return this.pollForActivityTaskAsync(request, null);
    }

    @Override
    public Future<ActivityTask> pollForActivityTaskAsync(final PollForActivityTaskRequest request, final AsyncHandler<PollForActivityTaskRequest, ActivityTask> asyncHandler) {
        return this.executorService.submit(new Callable<ActivityTask>(){

            @Override
            public ActivityTask call() throws Exception {
                ActivityTask result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.pollForActivityTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecisionTask> pollForDecisionTaskAsync(PollForDecisionTaskRequest request) {
        return this.pollForDecisionTaskAsync(request, null);
    }

    @Override
    public Future<DecisionTask> pollForDecisionTaskAsync(final PollForDecisionTaskRequest request, final AsyncHandler<PollForDecisionTaskRequest, DecisionTask> asyncHandler) {
        return this.executorService.submit(new Callable<DecisionTask>(){

            @Override
            public DecisionTask call() throws Exception {
                DecisionTask result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.pollForDecisionTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTaskStatus> recordActivityTaskHeartbeatAsync(RecordActivityTaskHeartbeatRequest request) {
        return this.recordActivityTaskHeartbeatAsync(request, null);
    }

    @Override
    public Future<ActivityTaskStatus> recordActivityTaskHeartbeatAsync(final RecordActivityTaskHeartbeatRequest request, final AsyncHandler<RecordActivityTaskHeartbeatRequest, ActivityTaskStatus> asyncHandler) {
        return this.executorService.submit(new Callable<ActivityTaskStatus>(){

            @Override
            public ActivityTaskStatus call() throws Exception {
                ActivityTaskStatus result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.recordActivityTaskHeartbeat(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerActivityTypeAsync(RegisterActivityTypeRequest request) {
        return this.registerActivityTypeAsync(request, null);
    }

    @Override
    public Future<Void> registerActivityTypeAsync(final RegisterActivityTypeRequest request, final AsyncHandler<RegisterActivityTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.registerActivityType(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerDomainAsync(RegisterDomainRequest request) {
        return this.registerDomainAsync(request, null);
    }

    @Override
    public Future<Void> registerDomainAsync(final RegisterDomainRequest request, final AsyncHandler<RegisterDomainRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.registerDomain(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerWorkflowTypeAsync(RegisterWorkflowTypeRequest request) {
        return this.registerWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<Void> registerWorkflowTypeAsync(final RegisterWorkflowTypeRequest request, final AsyncHandler<RegisterWorkflowTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.registerWorkflowType(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> requestCancelWorkflowExecutionAsync(RequestCancelWorkflowExecutionRequest request) {
        return this.requestCancelWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> requestCancelWorkflowExecutionAsync(final RequestCancelWorkflowExecutionRequest request, final AsyncHandler<RequestCancelWorkflowExecutionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.requestCancelWorkflowExecution(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCanceledAsync(RespondActivityTaskCanceledRequest request) {
        return this.respondActivityTaskCanceledAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskCanceledAsync(final RespondActivityTaskCanceledRequest request, final AsyncHandler<RespondActivityTaskCanceledRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskCanceled(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCompletedAsync(RespondActivityTaskCompletedRequest request) {
        return this.respondActivityTaskCompletedAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskCompletedAsync(final RespondActivityTaskCompletedRequest request, final AsyncHandler<RespondActivityTaskCompletedRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskCompleted(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskFailedAsync(RespondActivityTaskFailedRequest request) {
        return this.respondActivityTaskFailedAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskFailedAsync(final RespondActivityTaskFailedRequest request, final AsyncHandler<RespondActivityTaskFailedRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskFailed(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondDecisionTaskCompletedAsync(RespondDecisionTaskCompletedRequest request) {
        return this.respondDecisionTaskCompletedAsync(request, null);
    }

    @Override
    public Future<Void> respondDecisionTaskCompletedAsync(final RespondDecisionTaskCompletedRequest request, final AsyncHandler<RespondDecisionTaskCompletedRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.respondDecisionTaskCompleted(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> signalWorkflowExecutionAsync(SignalWorkflowExecutionRequest request) {
        return this.signalWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> signalWorkflowExecutionAsync(final SignalWorkflowExecutionRequest request, final AsyncHandler<SignalWorkflowExecutionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.signalWorkflowExecution(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Run> startWorkflowExecutionAsync(StartWorkflowExecutionRequest request) {
        return this.startWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Run> startWorkflowExecutionAsync(final StartWorkflowExecutionRequest request, final AsyncHandler<StartWorkflowExecutionRequest, Run> asyncHandler) {
        return this.executorService.submit(new Callable<Run>(){

            @Override
            public Run call() throws Exception {
                Run result;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.startWorkflowExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> terminateWorkflowExecutionAsync(TerminateWorkflowExecutionRequest request) {
        return this.terminateWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> terminateWorkflowExecutionAsync(final TerminateWorkflowExecutionRequest request, final AsyncHandler<TerminateWorkflowExecutionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.terminateWorkflowExecution(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

