/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterDomainRequestMarshaller
implements Marshaller<Request<RegisterDomainRequest>, RegisterDomainRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterDomainRequest> marshall(RegisterDomainRequest registerDomainRequest) {
        if (registerDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerDomainRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RegisterDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerDomainRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(registerDomainRequest.getName());
            }
            if (registerDomainRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(registerDomainRequest.getDescription());
            }
            if (registerDomainRequest.getWorkflowExecutionRetentionPeriodInDays() != null) {
                jsonGenerator.writeFieldName("workflowExecutionRetentionPeriodInDays").writeValue(registerDomainRequest.getWorkflowExecutionRetentionPeriodInDays());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

