/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.servicediscovery.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A complex type that identifies the namespaces that you want to list. You can choose to list public or private
 * namespaces.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceFilter" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class NamespaceFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specify the namespaces that you want to get using one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Gets the namespaces of the specified type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Gets the namespaces with the specified name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     * </p>
     * </li>
     * </ul>
     */
    private String name;
    /**
     * <p>
     * Specify the values that are applicable to the value that you specify for <code>Name</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     * <code>Namespace.Properties.HttpProperties.HttpName</code>.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> values;
    /**
     * <p>
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid
     * values for <code>Condition</code> are one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one value.
     * <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can specify
     * only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>, and
     * <code>HTTP_NAME</code>.
     * </p>
     * </li>
     * </ul>
     */
    private String condition;

    /**
     * <p>
     * Specify the namespaces that you want to get using one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Gets the namespaces of the specified type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Gets the namespaces with the specified name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     * </p>
     * </li>
     * </ul>
     * 
     * @param name
     *        Specify the namespaces that you want to get using one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Gets the namespaces of the specified type.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Gets the namespaces with the specified name.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     *        </p>
     *        </li>
     * @see NamespaceFilterName
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Specify the namespaces that you want to get using one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Gets the namespaces of the specified type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Gets the namespaces with the specified name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the namespaces that you want to get using one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TYPE</code>: Gets the namespaces of the specified type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>: Gets the namespaces with the specified name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     *         </p>
     *         </li>
     * @see NamespaceFilterName
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Specify the namespaces that you want to get using one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Gets the namespaces of the specified type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Gets the namespaces with the specified name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     * </p>
     * </li>
     * </ul>
     * 
     * @param name
     *        Specify the namespaces that you want to get using one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Gets the namespaces of the specified type.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Gets the namespaces with the specified name.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NamespaceFilterName
     */

    public NamespaceFilter withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Specify the namespaces that you want to get using one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Gets the namespaces of the specified type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Gets the namespaces with the specified name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     * </p>
     * </li>
     * </ul>
     * 
     * @param name
     *        Specify the namespaces that you want to get using one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Gets the namespaces of the specified type.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Gets the namespaces with the specified name.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Gets the namespaces with the specified HTTP name.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NamespaceFilterName
     */

    public NamespaceFilter withName(NamespaceFilterName name) {
        this.name = name.toString();
        return this;
    }

    /**
     * <p>
     * Specify the values that are applicable to the value that you specify for <code>Name</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     * <code>Namespace.Properties.HttpProperties.HttpName</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the values that are applicable to the value that you specify for <code>Name</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     *         <code>Namespace.Properties.HttpProperties.HttpName</code>.
     *         </p>
     *         </li>
     */

    public java.util.List<String> getValues() {
        return values;
    }

    /**
     * <p>
     * Specify the values that are applicable to the value that you specify for <code>Name</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     * <code>Namespace.Properties.HttpProperties.HttpName</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param values
     *        Specify the values that are applicable to the value that you specify for <code>Name</code>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     *        <code>Namespace.Properties.HttpProperties.HttpName</code>.
     *        </p>
     *        </li>
     */

    public void setValues(java.util.Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }

        this.values = new java.util.ArrayList<String>(values);
    }

    /**
     * <p>
     * Specify the values that are applicable to the value that you specify for <code>Name</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     * <code>Namespace.Properties.HttpProperties.HttpName</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setValues(java.util.Collection)} or {@link #withValues(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param values
     *        Specify the values that are applicable to the value that you specify for <code>Name</code>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     *        <code>Namespace.Properties.HttpProperties.HttpName</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public NamespaceFilter withValues(String... values) {
        if (this.values == null) {
            setValues(new java.util.ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specify the values that are applicable to the value that you specify for <code>Name</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     * <code>Namespace.Properties.HttpProperties.HttpName</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param values
     *        Specify the values that are applicable to the value that you specify for <code>Name</code>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>TYPE</code>: Specify <code>HTTP</code>, <code>DNS_PUBLIC</code>, or <code>DNS_PRIVATE</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NAME</code>: Specify the name of the namespace, which is found in <code>Namespace.Name</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>HTTP_NAME</code>: Specify the HTTP name of the namespace, which is found in
     *        <code>Namespace.Properties.HttpProperties.HttpName</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public NamespaceFilter withValues(java.util.Collection<String> values) {
        setValues(values);
        return this;
    }

    /**
     * <p>
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid
     * values for <code>Condition</code> are one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one value.
     * <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can specify
     * only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>, and
     * <code>HTTP_NAME</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param condition
     *        Specify the operator that you want to use to determine whether a namespace matches the specified value.
     *        Valid values for <code>Condition</code> are one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one
     *        value. <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     *        <code>EQ</code> is the default condition and can be omitted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can
     *        specify only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>,
     *        and <code>HTTP_NAME</code>.
     *        </p>
     *        </li>
     * @see FilterCondition
     */

    public void setCondition(String condition) {
        this.condition = condition;
    }

    /**
     * <p>
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid
     * values for <code>Condition</code> are one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one value.
     * <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can specify
     * only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>, and
     * <code>HTTP_NAME</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the operator that you want to use to determine whether a namespace matches the specified value.
     *         Valid values for <code>Condition</code> are one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one
     *         value. <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     *         <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can
     *         specify only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>,
     *         and <code>HTTP_NAME</code>.
     *         </p>
     *         </li>
     * @see FilterCondition
     */

    public String getCondition() {
        return this.condition;
    }

    /**
     * <p>
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid
     * values for <code>Condition</code> are one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one value.
     * <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can specify
     * only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>, and
     * <code>HTTP_NAME</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param condition
     *        Specify the operator that you want to use to determine whether a namespace matches the specified value.
     *        Valid values for <code>Condition</code> are one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one
     *        value. <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     *        <code>EQ</code> is the default condition and can be omitted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can
     *        specify only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>,
     *        and <code>HTTP_NAME</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FilterCondition
     */

    public NamespaceFilter withCondition(String condition) {
        setCondition(condition);
        return this;
    }

    /**
     * <p>
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid
     * values for <code>Condition</code> are one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one value.
     * <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can specify
     * only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>, and
     * <code>HTTP_NAME</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param condition
     *        Specify the operator that you want to use to determine whether a namespace matches the specified value.
     *        Valid values for <code>Condition</code> are one of the following.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>EQ</code>: When you specify <code>EQ</code> for <code>Condition</code>, you can specify only one
     *        value. <code>EQ</code> is supported for <code>TYPE</code>, <code>NAME</code>, and <code>HTTP_NAME</code>.
     *        <code>EQ</code> is the default condition and can be omitted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>BEGINS_WITH</code>: When you specify <code>BEGINS_WITH</code> for <code>Condition</code>, you can
     *        specify only one value. <code>BEGINS_WITH</code> is supported for <code>TYPE</code>, <code>NAME</code>,
     *        and <code>HTTP_NAME</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FilterCondition
     */

    public NamespaceFilter withCondition(FilterCondition condition) {
        this.condition = condition.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getValues() != null)
            sb.append("Values: ").append(getValues()).append(",");
        if (getCondition() != null)
            sb.append("Condition: ").append(getCondition());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof NamespaceFilter == false)
            return false;
        NamespaceFilter other = (NamespaceFilter) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getValues() == null ^ this.getValues() == null)
            return false;
        if (other.getValues() != null && other.getValues().equals(this.getValues()) == false)
            return false;
        if (other.getCondition() == null ^ this.getCondition() == null)
            return false;
        if (other.getCondition() != null && other.getCondition().equals(this.getCondition()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getValues() == null) ? 0 : getValues().hashCode());
        hashCode = prime * hashCode + ((getCondition() == null) ? 0 : getCondition().hashCode());
        return hashCode;
    }

    @Override
    public NamespaceFilter clone() {
        try {
            return (NamespaceFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.servicediscovery.model.transform.NamespaceFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
