/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ListPortfoliosForProductRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPortfoliosForProductRequestMarshaller
implements Marshaller<Request<ListPortfoliosForProductRequest>, ListPortfoliosForProductRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPortfoliosForProductRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPortfoliosForProductRequest> marshall(ListPortfoliosForProductRequest listPortfoliosForProductRequest) {
        if (listPortfoliosForProductRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPortfoliosForProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ListPortfoliosForProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listPortfoliosForProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(listPortfoliosForProductRequest.getAcceptLanguage());
            }
            if (listPortfoliosForProductRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(listPortfoliosForProductRequest.getProductId());
            }
            if (listPortfoliosForProductRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(listPortfoliosForProductRequest.getPageToken());
            }
            if (listPortfoliosForProductRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(listPortfoliosForProductRequest.getPageSize().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

