/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.servicecatalog.AWSServiceCatalogAsync;
import com.amazonaws.services.servicecatalog.AWSServiceCatalogClient;
import com.amazonaws.services.servicecatalog.model.DescribeProductRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductResult;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewResult;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersResult;
import com.amazonaws.services.servicecatalog.model.DescribeRecordRequest;
import com.amazonaws.services.servicecatalog.model.DescribeRecordResult;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsRequest;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsResult;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryRequest;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryResult;
import com.amazonaws.services.servicecatalog.model.ProvisionProductRequest;
import com.amazonaws.services.servicecatalog.model.ProvisionProductResult;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsRequest;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsResult;
import com.amazonaws.services.servicecatalog.model.SearchProductsRequest;
import com.amazonaws.services.servicecatalog.model.SearchProductsResult;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductResult;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSServiceCatalogAsyncClient
extends AWSServiceCatalogClient
implements AWSServiceCatalogAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSServiceCatalogAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSServiceCatalogAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeProductResult> describeProductAsync(DescribeProductRequest request) {
        return this.describeProductAsync(request, null);
    }

    @Override
    public Future<DescribeProductResult> describeProductAsync(final DescribeProductRequest request, final AsyncHandler<DescribeProductRequest, DescribeProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProductResult>(){

            @Override
            public DescribeProductResult call() throws Exception {
                DescribeProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProductViewResult> describeProductViewAsync(DescribeProductViewRequest request) {
        return this.describeProductViewAsync(request, null);
    }

    @Override
    public Future<DescribeProductViewResult> describeProductViewAsync(final DescribeProductViewRequest request, final AsyncHandler<DescribeProductViewRequest, DescribeProductViewResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProductViewResult>(){

            @Override
            public DescribeProductViewResult call() throws Exception {
                DescribeProductViewResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProductView(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(DescribeProvisioningParametersRequest request) {
        return this.describeProvisioningParametersAsync(request, null);
    }

    @Override
    public Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(final DescribeProvisioningParametersRequest request, final AsyncHandler<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProvisioningParametersResult>(){

            @Override
            public DescribeProvisioningParametersResult call() throws Exception {
                DescribeProvisioningParametersResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProvisioningParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecordResult> describeRecordAsync(DescribeRecordRequest request) {
        return this.describeRecordAsync(request, null);
    }

    @Override
    public Future<DescribeRecordResult> describeRecordAsync(final DescribeRecordRequest request, final AsyncHandler<DescribeRecordRequest, DescribeRecordResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRecordResult>(){

            @Override
            public DescribeRecordResult call() throws Exception {
                DescribeRecordResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeRecord(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLaunchPathsResult> listLaunchPathsAsync(ListLaunchPathsRequest request) {
        return this.listLaunchPathsAsync(request, null);
    }

    @Override
    public Future<ListLaunchPathsResult> listLaunchPathsAsync(final ListLaunchPathsRequest request, final AsyncHandler<ListLaunchPathsRequest, ListLaunchPathsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListLaunchPathsResult>(){

            @Override
            public ListLaunchPathsResult call() throws Exception {
                ListLaunchPathsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listLaunchPaths(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordHistoryResult> listRecordHistoryAsync(ListRecordHistoryRequest request) {
        return this.listRecordHistoryAsync(request, null);
    }

    @Override
    public Future<ListRecordHistoryResult> listRecordHistoryAsync(final ListRecordHistoryRequest request, final AsyncHandler<ListRecordHistoryRequest, ListRecordHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRecordHistoryResult>(){

            @Override
            public ListRecordHistoryResult call() throws Exception {
                ListRecordHistoryResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listRecordHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ProvisionProductResult> provisionProductAsync(ProvisionProductRequest request) {
        return this.provisionProductAsync(request, null);
    }

    @Override
    public Future<ProvisionProductResult> provisionProductAsync(final ProvisionProductRequest request, final AsyncHandler<ProvisionProductRequest, ProvisionProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<ProvisionProductResult>(){

            @Override
            public ProvisionProductResult call() throws Exception {
                ProvisionProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.provisionProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(ScanProvisionedProductsRequest request) {
        return this.scanProvisionedProductsAsync(request, null);
    }

    @Override
    public Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(final ScanProvisionedProductsRequest request, final AsyncHandler<ScanProvisionedProductsRequest, ScanProvisionedProductsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScanProvisionedProductsResult>(){

            @Override
            public ScanProvisionedProductsResult call() throws Exception {
                ScanProvisionedProductsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.scanProvisionedProducts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchProductsResult> searchProductsAsync(SearchProductsRequest request) {
        return this.searchProductsAsync(request, null);
    }

    @Override
    public Future<SearchProductsResult> searchProductsAsync(final SearchProductsRequest request, final AsyncHandler<SearchProductsRequest, SearchProductsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchProductsResult>(){

            @Override
            public SearchProductsResult call() throws Exception {
                SearchProductsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.searchProducts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(TerminateProvisionedProductRequest request) {
        return this.terminateProvisionedProductAsync(request, null);
    }

    @Override
    public Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(final TerminateProvisionedProductRequest request, final AsyncHandler<TerminateProvisionedProductRequest, TerminateProvisionedProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<TerminateProvisionedProductResult>(){

            @Override
            public TerminateProvisionedProductResult call() throws Exception {
                TerminateProvisionedProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.terminateProvisionedProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(UpdateProvisionedProductRequest request) {
        return this.updateProvisionedProductAsync(request, null);
    }

    @Override
    public Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(final UpdateProvisionedProductRequest request, final AsyncHandler<UpdateProvisionedProductRequest, UpdateProvisionedProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProvisionedProductResult>(){

            @Override
            public UpdateProvisionedProductResult call() throws Exception {
                UpdateProvisionedProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updateProvisionedProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

