/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.servermigration.AWSServerMigrationAsync;
import com.amazonaws.services.servermigration.AWSServerMigrationAsyncClientBuilder;
import com.amazonaws.services.servermigration.AWSServerMigrationClient;
import com.amazonaws.services.servermigration.model.CreateReplicationJobRequest;
import com.amazonaws.services.servermigration.model.CreateReplicationJobResult;
import com.amazonaws.services.servermigration.model.DeleteReplicationJobRequest;
import com.amazonaws.services.servermigration.model.DeleteReplicationJobResult;
import com.amazonaws.services.servermigration.model.DeleteServerCatalogRequest;
import com.amazonaws.services.servermigration.model.DeleteServerCatalogResult;
import com.amazonaws.services.servermigration.model.DisassociateConnectorRequest;
import com.amazonaws.services.servermigration.model.DisassociateConnectorResult;
import com.amazonaws.services.servermigration.model.GetConnectorsRequest;
import com.amazonaws.services.servermigration.model.GetConnectorsResult;
import com.amazonaws.services.servermigration.model.GetReplicationJobsRequest;
import com.amazonaws.services.servermigration.model.GetReplicationJobsResult;
import com.amazonaws.services.servermigration.model.GetReplicationRunsRequest;
import com.amazonaws.services.servermigration.model.GetReplicationRunsResult;
import com.amazonaws.services.servermigration.model.GetServersRequest;
import com.amazonaws.services.servermigration.model.GetServersResult;
import com.amazonaws.services.servermigration.model.ImportServerCatalogRequest;
import com.amazonaws.services.servermigration.model.ImportServerCatalogResult;
import com.amazonaws.services.servermigration.model.StartOnDemandReplicationRunRequest;
import com.amazonaws.services.servermigration.model.StartOnDemandReplicationRunResult;
import com.amazonaws.services.servermigration.model.UpdateReplicationJobRequest;
import com.amazonaws.services.servermigration.model.UpdateReplicationJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSServerMigrationAsyncClient
extends AWSServerMigrationClient
implements AWSServerMigrationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSServerMigrationAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSServerMigrationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSServerMigrationAsyncClientBuilder asyncBuilder() {
        return AWSServerMigrationAsyncClientBuilder.standard();
    }

    AWSServerMigrationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateReplicationJobResult> createReplicationJobAsync(CreateReplicationJobRequest request) {
        return this.createReplicationJobAsync(request, null);
    }

    @Override
    public Future<CreateReplicationJobResult> createReplicationJobAsync(CreateReplicationJobRequest request, final AsyncHandler<CreateReplicationJobRequest, CreateReplicationJobResult> asyncHandler) {
        final CreateReplicationJobRequest finalRequest = (CreateReplicationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateReplicationJobResult>(){

            @Override
            public CreateReplicationJobResult call() throws Exception {
                CreateReplicationJobResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeCreateReplicationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReplicationJobResult> deleteReplicationJobAsync(DeleteReplicationJobRequest request) {
        return this.deleteReplicationJobAsync(request, null);
    }

    @Override
    public Future<DeleteReplicationJobResult> deleteReplicationJobAsync(DeleteReplicationJobRequest request, final AsyncHandler<DeleteReplicationJobRequest, DeleteReplicationJobResult> asyncHandler) {
        final DeleteReplicationJobRequest finalRequest = (DeleteReplicationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteReplicationJobResult>(){

            @Override
            public DeleteReplicationJobResult call() throws Exception {
                DeleteReplicationJobResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeDeleteReplicationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServerCatalogResult> deleteServerCatalogAsync(DeleteServerCatalogRequest request) {
        return this.deleteServerCatalogAsync(request, null);
    }

    @Override
    public Future<DeleteServerCatalogResult> deleteServerCatalogAsync(DeleteServerCatalogRequest request, final AsyncHandler<DeleteServerCatalogRequest, DeleteServerCatalogResult> asyncHandler) {
        final DeleteServerCatalogRequest finalRequest = (DeleteServerCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteServerCatalogResult>(){

            @Override
            public DeleteServerCatalogResult call() throws Exception {
                DeleteServerCatalogResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeDeleteServerCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateConnectorResult> disassociateConnectorAsync(DisassociateConnectorRequest request) {
        return this.disassociateConnectorAsync(request, null);
    }

    @Override
    public Future<DisassociateConnectorResult> disassociateConnectorAsync(DisassociateConnectorRequest request, final AsyncHandler<DisassociateConnectorRequest, DisassociateConnectorResult> asyncHandler) {
        final DisassociateConnectorRequest finalRequest = (DisassociateConnectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateConnectorResult>(){

            @Override
            public DisassociateConnectorResult call() throws Exception {
                DisassociateConnectorResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeDisassociateConnector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectorsResult> getConnectorsAsync(GetConnectorsRequest request) {
        return this.getConnectorsAsync(request, null);
    }

    @Override
    public Future<GetConnectorsResult> getConnectorsAsync(GetConnectorsRequest request, final AsyncHandler<GetConnectorsRequest, GetConnectorsResult> asyncHandler) {
        final GetConnectorsRequest finalRequest = (GetConnectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectorsResult>(){

            @Override
            public GetConnectorsResult call() throws Exception {
                GetConnectorsResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeGetConnectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReplicationJobsResult> getReplicationJobsAsync(GetReplicationJobsRequest request) {
        return this.getReplicationJobsAsync(request, null);
    }

    @Override
    public Future<GetReplicationJobsResult> getReplicationJobsAsync(GetReplicationJobsRequest request, final AsyncHandler<GetReplicationJobsRequest, GetReplicationJobsResult> asyncHandler) {
        final GetReplicationJobsRequest finalRequest = (GetReplicationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReplicationJobsResult>(){

            @Override
            public GetReplicationJobsResult call() throws Exception {
                GetReplicationJobsResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeGetReplicationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReplicationRunsResult> getReplicationRunsAsync(GetReplicationRunsRequest request) {
        return this.getReplicationRunsAsync(request, null);
    }

    @Override
    public Future<GetReplicationRunsResult> getReplicationRunsAsync(GetReplicationRunsRequest request, final AsyncHandler<GetReplicationRunsRequest, GetReplicationRunsResult> asyncHandler) {
        final GetReplicationRunsRequest finalRequest = (GetReplicationRunsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReplicationRunsResult>(){

            @Override
            public GetReplicationRunsResult call() throws Exception {
                GetReplicationRunsResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeGetReplicationRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServersResult> getServersAsync(GetServersRequest request) {
        return this.getServersAsync(request, null);
    }

    @Override
    public Future<GetServersResult> getServersAsync(GetServersRequest request, final AsyncHandler<GetServersRequest, GetServersResult> asyncHandler) {
        final GetServersRequest finalRequest = (GetServersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServersResult>(){

            @Override
            public GetServersResult call() throws Exception {
                GetServersResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeGetServers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportServerCatalogResult> importServerCatalogAsync(ImportServerCatalogRequest request) {
        return this.importServerCatalogAsync(request, null);
    }

    @Override
    public Future<ImportServerCatalogResult> importServerCatalogAsync(ImportServerCatalogRequest request, final AsyncHandler<ImportServerCatalogRequest, ImportServerCatalogResult> asyncHandler) {
        final ImportServerCatalogRequest finalRequest = (ImportServerCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportServerCatalogResult>(){

            @Override
            public ImportServerCatalogResult call() throws Exception {
                ImportServerCatalogResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeImportServerCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartOnDemandReplicationRunResult> startOnDemandReplicationRunAsync(StartOnDemandReplicationRunRequest request) {
        return this.startOnDemandReplicationRunAsync(request, null);
    }

    @Override
    public Future<StartOnDemandReplicationRunResult> startOnDemandReplicationRunAsync(StartOnDemandReplicationRunRequest request, final AsyncHandler<StartOnDemandReplicationRunRequest, StartOnDemandReplicationRunResult> asyncHandler) {
        final StartOnDemandReplicationRunRequest finalRequest = (StartOnDemandReplicationRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartOnDemandReplicationRunResult>(){

            @Override
            public StartOnDemandReplicationRunResult call() throws Exception {
                StartOnDemandReplicationRunResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeStartOnDemandReplicationRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReplicationJobResult> updateReplicationJobAsync(UpdateReplicationJobRequest request) {
        return this.updateReplicationJobAsync(request, null);
    }

    @Override
    public Future<UpdateReplicationJobResult> updateReplicationJobAsync(UpdateReplicationJobRequest request, final AsyncHandler<UpdateReplicationJobRequest, UpdateReplicationJobResult> asyncHandler) {
        final UpdateReplicationJobRequest finalRequest = (UpdateReplicationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReplicationJobResult>(){

            @Override
            public UpdateReplicationJobResult call() throws Exception {
                UpdateReplicationJobResult result = null;
                try {
                    result = AWSServerMigrationAsyncClient.this.executeUpdateReplicationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

