/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securitylake.model.LogSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLogSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<LogSource> sources;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLogSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<LogSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<LogSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<LogSource>(sources);
    }

    public ListLogSourcesResult withSources(LogSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<LogSource>(sources.length));
        }
        for (LogSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public ListLogSourcesResult withSources(Collection<LogSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesResult)) {
            return false;
        }
        ListLogSourcesResult other = (ListLogSourcesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public ListLogSourcesResult clone() {
        try {
            return (ListLogSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

