/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListLogSourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> inputOrder;
    private Map<String, Map<String, List<String>>> listAllDimensions;
    private List<String> listSingleDimension;
    private Map<String, List<String>> listTwoDimensions;
    private Integer maxResults;
    private String nextToken;

    public List<String> getInputOrder() {
        return this.inputOrder;
    }

    public void setInputOrder(Collection<String> inputOrder) {
        if (inputOrder == null) {
            this.inputOrder = null;
            return;
        }
        this.inputOrder = new ArrayList<String>(inputOrder);
    }

    public ListLogSourcesRequest withInputOrder(String ... inputOrder) {
        if (this.inputOrder == null) {
            this.setInputOrder(new ArrayList<String>(inputOrder.length));
        }
        for (String ele : inputOrder) {
            this.inputOrder.add(ele);
        }
        return this;
    }

    public ListLogSourcesRequest withInputOrder(Collection<String> inputOrder) {
        this.setInputOrder(inputOrder);
        return this;
    }

    public ListLogSourcesRequest withInputOrder(Dimension ... inputOrder) {
        ArrayList<String> inputOrderCopy = new ArrayList<String>(inputOrder.length);
        for (Dimension value : inputOrder) {
            inputOrderCopy.add(value.toString());
        }
        if (this.getInputOrder() == null) {
            this.setInputOrder(inputOrderCopy);
        } else {
            this.getInputOrder().addAll(inputOrderCopy);
        }
        return this;
    }

    public Map<String, Map<String, List<String>>> getListAllDimensions() {
        return this.listAllDimensions;
    }

    public void setListAllDimensions(Map<String, Map<String, List<String>>> listAllDimensions) {
        this.listAllDimensions = listAllDimensions;
    }

    public ListLogSourcesRequest withListAllDimensions(Map<String, Map<String, List<String>>> listAllDimensions) {
        this.setListAllDimensions(listAllDimensions);
        return this;
    }

    public ListLogSourcesRequest addListAllDimensionsEntry(String key, Map<String, List<String>> value) {
        if (null == this.listAllDimensions) {
            this.listAllDimensions = new HashMap<String, Map<String, List<String>>>();
        }
        if (this.listAllDimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.listAllDimensions.put(key, value);
        return this;
    }

    public ListLogSourcesRequest clearListAllDimensionsEntries() {
        this.listAllDimensions = null;
        return this;
    }

    public List<String> getListSingleDimension() {
        return this.listSingleDimension;
    }

    public void setListSingleDimension(Collection<String> listSingleDimension) {
        if (listSingleDimension == null) {
            this.listSingleDimension = null;
            return;
        }
        this.listSingleDimension = new ArrayList<String>(listSingleDimension);
    }

    public ListLogSourcesRequest withListSingleDimension(String ... listSingleDimension) {
        if (this.listSingleDimension == null) {
            this.setListSingleDimension(new ArrayList<String>(listSingleDimension.length));
        }
        for (String ele : listSingleDimension) {
            this.listSingleDimension.add(ele);
        }
        return this;
    }

    public ListLogSourcesRequest withListSingleDimension(Collection<String> listSingleDimension) {
        this.setListSingleDimension(listSingleDimension);
        return this;
    }

    public Map<String, List<String>> getListTwoDimensions() {
        return this.listTwoDimensions;
    }

    public void setListTwoDimensions(Map<String, List<String>> listTwoDimensions) {
        this.listTwoDimensions = listTwoDimensions;
    }

    public ListLogSourcesRequest withListTwoDimensions(Map<String, List<String>> listTwoDimensions) {
        this.setListTwoDimensions(listTwoDimensions);
        return this;
    }

    public ListLogSourcesRequest addListTwoDimensionsEntry(String key, List<String> value) {
        if (null == this.listTwoDimensions) {
            this.listTwoDimensions = new HashMap<String, List<String>>();
        }
        if (this.listTwoDimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.listTwoDimensions.put(key, value);
        return this;
    }

    public ListLogSourcesRequest clearListTwoDimensionsEntries() {
        this.listTwoDimensions = null;
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListLogSourcesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLogSourcesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputOrder() != null) {
            sb.append("InputOrder: ").append(this.getInputOrder()).append(",");
        }
        if (this.getListAllDimensions() != null) {
            sb.append("ListAllDimensions: ").append(this.getListAllDimensions()).append(",");
        }
        if (this.getListSingleDimension() != null) {
            sb.append("ListSingleDimension: ").append(this.getListSingleDimension()).append(",");
        }
        if (this.getListTwoDimensions() != null) {
            sb.append("ListTwoDimensions: ").append(this.getListTwoDimensions()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesRequest)) {
            return false;
        }
        ListLogSourcesRequest other = (ListLogSourcesRequest)obj;
        if (other.getInputOrder() == null ^ this.getInputOrder() == null) {
            return false;
        }
        if (other.getInputOrder() != null && !other.getInputOrder().equals(this.getInputOrder())) {
            return false;
        }
        if (other.getListAllDimensions() == null ^ this.getListAllDimensions() == null) {
            return false;
        }
        if (other.getListAllDimensions() != null && !other.getListAllDimensions().equals(this.getListAllDimensions())) {
            return false;
        }
        if (other.getListSingleDimension() == null ^ this.getListSingleDimension() == null) {
            return false;
        }
        if (other.getListSingleDimension() != null && !other.getListSingleDimension().equals(this.getListSingleDimension())) {
            return false;
        }
        if (other.getListTwoDimensions() == null ^ this.getListTwoDimensions() == null) {
            return false;
        }
        if (other.getListTwoDimensions() != null && !other.getListTwoDimensions().equals(this.getListTwoDimensions())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputOrder() == null ? 0 : this.getInputOrder().hashCode());
        hashCode = 31 * hashCode + (this.getListAllDimensions() == null ? 0 : this.getListAllDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getListSingleDimension() == null ? 0 : this.getListSingleDimension().hashCode());
        hashCode = 31 * hashCode + (this.getListTwoDimensions() == null ? 0 : this.getListTwoDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLogSourcesRequest clone() {
        return (ListLogSourcesRequest)super.clone();
    }
}

