/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securitylake;

import javax.annotation.Generated;

import com.amazonaws.services.securitylake.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonSecurityLake}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSecurityLake implements AmazonSecurityLake {

    protected AbstractAmazonSecurityLake() {
    }

    @Override
    public CreateAwsLogSourceResult createAwsLogSource(CreateAwsLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomLogSourceResult createCustomLogSource(CreateCustomLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatalakeResult createDatalake(CreateDatalakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatalakeAutoEnableResult createDatalakeAutoEnable(CreateDatalakeAutoEnableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatalakeDelegatedAdminResult createDatalakeDelegatedAdmin(CreateDatalakeDelegatedAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatalakeExceptionsSubscriptionResult createDatalakeExceptionsSubscription(CreateDatalakeExceptionsSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriberResult createSubscriber(CreateSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionNotificationConfigurationResult createSubscriptionNotificationConfiguration(
            CreateSubscriptionNotificationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAwsLogSourceResult deleteAwsLogSource(DeleteAwsLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomLogSourceResult deleteCustomLogSource(DeleteCustomLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatalakeResult deleteDatalake(DeleteDatalakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatalakeAutoEnableResult deleteDatalakeAutoEnable(DeleteDatalakeAutoEnableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatalakeDelegatedAdminResult deleteDatalakeDelegatedAdmin(DeleteDatalakeDelegatedAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatalakeExceptionsSubscriptionResult deleteDatalakeExceptionsSubscription(DeleteDatalakeExceptionsSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriberResult deleteSubscriber(DeleteSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriptionNotificationConfigurationResult deleteSubscriptionNotificationConfiguration(
            DeleteSubscriptionNotificationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatalakeResult getDatalake(GetDatalakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatalakeAutoEnableResult getDatalakeAutoEnable(GetDatalakeAutoEnableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatalakeExceptionsExpiryResult getDatalakeExceptionsExpiry(GetDatalakeExceptionsExpiryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatalakeExceptionsSubscriptionResult getDatalakeExceptionsSubscription(GetDatalakeExceptionsSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatalakeStatusResult getDatalakeStatus(GetDatalakeStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriberResult getSubscriber(GetSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatalakeExceptionsResult listDatalakeExceptions(ListDatalakeExceptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLogSourcesResult listLogSources(ListLogSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscribersResult listSubscribers(ListSubscribersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatalakeResult updateDatalake(UpdateDatalakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatalakeExceptionsExpiryResult updateDatalakeExceptionsExpiry(UpdateDatalakeExceptionsExpiryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatalakeExceptionsSubscriptionResult updateDatalakeExceptionsSubscription(UpdateDatalakeExceptionsSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriberResult updateSubscriber(UpdateSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionNotificationConfigurationResult updateSubscriptionNotificationConfiguration(
            UpdateSubscriptionNotificationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
