/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.NetworkPathComponentDetails;
import com.amazonaws.services.securityhub.model.transform.NetworkHeaderMarshaller;
import java.io.Serializable;

public class NetworkHeader
implements Serializable,
Cloneable,
StructuredPojo {
    private String protocol;
    private NetworkPathComponentDetails destination;
    private NetworkPathComponentDetails source;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public NetworkHeader withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setDestination(NetworkPathComponentDetails destination) {
        this.destination = destination;
    }

    public NetworkPathComponentDetails getDestination() {
        return this.destination;
    }

    public NetworkHeader withDestination(NetworkPathComponentDetails destination) {
        this.setDestination(destination);
        return this;
    }

    public void setSource(NetworkPathComponentDetails source) {
        this.source = source;
    }

    public NetworkPathComponentDetails getSource() {
        return this.source;
    }

    public NetworkHeader withSource(NetworkPathComponentDetails source) {
        this.setSource(source);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkHeader)) {
            return false;
        }
        NetworkHeader other = (NetworkHeader)obj;
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        return other.getSource() == null || other.getSource().equals(this.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        return hashCode;
    }

    public NetworkHeader clone() {
        try {
            return (NetworkHeader)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkHeaderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

